/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.service.ServiceRevision;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.OrderedFuture;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class RecoveringRaftProxyClient
implements RaftProxyClient {
    private static final SessionId DEFAULT_SESSION_ID = SessionId.from(0L);
    private final String name;
    private final ServiceType serviceType;
    private final ServiceRevision revision;
    private final RaftProxyClient.Builder proxyClientBuilder;
    private final Scheduler scheduler;
    private Logger log;
    private volatile OrderedFuture<RaftProxyClient> clientFuture;
    private volatile RaftProxyClient client;
    private volatile RaftProxy.State state = RaftProxy.State.SUSPENDED;
    private final Set<Consumer<RaftProxy.State>> stateChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Set<Consumer<RaftEvent>> eventListeners = Sets.newCopyOnWriteArraySet();
    private Scheduled recoverTask;
    private volatile boolean open = false;

    public RecoveringRaftProxyClient(String clientId, String name, ServiceType serviceType, ServiceRevision revision, RaftProxyClient.Builder proxyClientBuilder, Scheduler scheduler) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.serviceType = (ServiceType)Preconditions.checkNotNull((Object)serviceType);
        this.revision = (ServiceRevision)Preconditions.checkNotNull((Object)revision);
        this.proxyClientBuilder = (RaftProxyClient.Builder)Preconditions.checkNotNull((Object)proxyClientBuilder);
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftClient.class).addValue((Object)clientId).build());
    }

    @Override
    public SessionId sessionId() {
        RaftProxyClient client = this.client;
        return client != null ? client.sessionId() : DEFAULT_SESSION_ID;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Override
    public ServiceRevision revision() {
        RaftProxyClient client = this.client;
        return client != null ? client.revision() : this.revision;
    }

    @Override
    public RaftProxy.State getState() {
        return this.state;
    }

    private synchronized void onStateChange(RaftProxy.State state) {
        if (this.state != state) {
            if (state == RaftProxy.State.CLOSED) {
                if (this.open) {
                    this.onStateChange(RaftProxy.State.SUSPENDED);
                    this.recover();
                } else {
                    this.log.debug("State changed: {}", (Object)state);
                    this.state = state;
                    this.stateChangeListeners.forEach(l -> l.accept(state));
                }
            } else {
                this.log.debug("State changed: {}", (Object)state);
                this.state = state;
                this.stateChangeListeners.forEach(l -> l.accept(state));
            }
        }
    }

    @Override
    public void addStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.stateChangeListeners.add(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"client not open");
    }

    private void recover() {
        this.client = null;
        this.openClient();
    }

    private CompletableFuture<RaftProxyClient> openClient() {
        if (this.open) {
            this.log.debug("Opening proxy session");
            this.clientFuture = new OrderedFuture();
            this.openClient((CompletableFuture<RaftProxyClient>)this.clientFuture);
            return this.clientFuture.thenApply(client -> {
                RecoveringRaftProxyClient recoveringRaftProxyClient = this;
                synchronized (recoveringRaftProxyClient) {
                    this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftProxy.class).addValue((Object)client.sessionId()).add("type", (Object)client.serviceType()).add("name", (Object)client.name()).build());
                    this.client = client;
                    client.addStateChangeListener(this::onStateChange);
                    this.eventListeners.forEach(client::addEventListener);
                    this.onStateChange(RaftProxy.State.CONNECTED);
                }
                return client;
            });
        }
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("Client not open"));
    }

    private void openClient(CompletableFuture<RaftProxyClient> future) {
        this.proxyClientBuilder.buildAsync().whenComplete((client, error) -> {
            if (error == null) {
                future.complete((RaftProxyClient)client);
            } else {
                this.recoverTask = this.scheduler.schedule(Duration.ofSeconds(1L), () -> this.openClient(future));
            }
        });
    }

    @Override
    public CompletableFuture<byte[]> execute(RaftOperation operation) {
        this.checkOpen();
        RaftProxyClient client = this.client;
        if (client != null) {
            return client.execute(operation);
        }
        return this.clientFuture.thenCompose(c -> c.execute(operation));
    }

    @Override
    public synchronized void addEventListener(Consumer<RaftEvent> consumer) {
        this.checkOpen();
        this.eventListeners.add(consumer);
        RaftProxyClient client = this.client;
        if (client != null) {
            client.addEventListener(consumer);
        }
    }

    @Override
    public synchronized void removeEventListener(Consumer<RaftEvent> consumer) {
        this.checkOpen();
        this.eventListeners.remove(consumer);
        RaftProxyClient client = this.client;
        if (client != null) {
            client.removeEventListener(consumer);
        }
    }

    public synchronized CompletableFuture<RaftProxyClient> open() {
        if (!this.open) {
            this.open = true;
            return this.openClient().thenApply(c -> this);
        }
        return CompletableFuture.completedFuture(this);
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized CompletableFuture<Void> close() {
        if (this.open) {
            RaftProxyClient client;
            this.open = false;
            if (this.recoverTask != null) {
                this.recoverTask.cancel();
            }
            if ((client = this.client) != null) {
                return client.close();
            }
            return this.clientFuture.thenCompose(c -> c.close());
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.client.name()).add("serviceType", (Object)this.client.serviceType()).add("state", (Object)this.state).toString();
    }
}

