/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.impl.DefaultRaftClient;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.utils.concurrent.ThreadModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public interface RaftClient {
    public static Builder newBuilder() {
        return RaftClient.newBuilder(Collections.EMPTY_LIST);
    }

    public static Builder newBuilder(MemberId ... cluster) {
        return RaftClient.newBuilder(Arrays.asList(cluster));
    }

    public static Builder newBuilder(Collection<MemberId> cluster) {
        return new DefaultRaftClient.Builder(cluster);
    }

    public String clientId();

    public RaftMetadataClient metadata();

    public RaftProxy.Builder newProxyBuilder();

    default public CompletableFuture<RaftClient> connect() {
        return this.connect((Collection<MemberId>)null);
    }

    default public CompletableFuture<RaftClient> connect(MemberId ... members) {
        if (members == null || members.length == 0) {
            return this.connect();
        }
        return this.connect(Arrays.asList(members));
    }

    public CompletableFuture<RaftClient> connect(Collection<MemberId> var1);

    public CompletableFuture<Void> close();

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftClient> {
        protected final Collection<MemberId> cluster;
        protected String clientId = UUID.randomUUID().toString();
        protected MemberId nodeId;
        protected RaftClientProtocol protocol;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Runtime.getRuntime().availableProcessors();

        protected Builder(Collection<MemberId> cluster) {
            this.cluster = (Collection)Preconditions.checkNotNull(cluster, (Object)"cluster cannot be null");
        }

        public Builder withClientId(String clientId) {
            this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
            return this;
        }

        public Builder withMemberId(MemberId nodeId) {
            this.nodeId = (MemberId)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId cannot be null");
            return this;
        }

        public Builder withProtocol(RaftClientProtocol protocol) {
            this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }
    }
}

