/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RaftSessionRegistry {
    private final Map<Long, RaftSessionContext> sessions = new ConcurrentHashMap<Long, RaftSessionContext>();
    private final Map<ServiceId, Map<Long, RaftSessionContext>> serviceSessions = new ConcurrentHashMap<ServiceId, Map<Long, RaftSessionContext>>();

    public RaftSessionContext addSession(RaftSessionContext session) {
        RaftSessionContext existingSession = this.sessions.putIfAbsent((Long)session.sessionId().id(), session);
        if (existingSession == null) {
            this.serviceSessions.computeIfAbsent(session.getService().serviceId(), id -> new ConcurrentHashMap()).put(session.sessionId().id(), session);
            return session;
        }
        return existingSession;
    }

    public RaftSessionContext removeSession(SessionId sessionId) {
        RaftSessionContext session = this.sessions.remove(sessionId.id());
        Map<Long, RaftSessionContext> serviceSessions = this.serviceSessions.get((Object)session.getService().serviceId());
        if (serviceSessions != null) {
            serviceSessions.remove(session.sessionId().id());
        }
        return session;
    }

    public RaftSessionContext getSession(SessionId sessionId) {
        return this.getSession((Long)sessionId.id());
    }

    public RaftSessionContext getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    public Collection<RaftSessionContext> getSessions() {
        return this.sessions.values();
    }

    public Collection<RaftSessionContext> getSessions(ServiceId serviceId) {
        Map<Long, RaftSessionContext> sessions = this.serviceSessions.get((Object)serviceId);
        return sessions != null ? sessions.values() : Collections.emptyList();
    }

    public void removeSessions(ServiceId serviceId) {
        this.sessions.entrySet().removeIf(e -> ((RaftSessionContext)e.getValue()).getService().serviceId().equals((Object)serviceId));
    }
}

