/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import io.atomix.protocols.raft.protocol.ConfigurationRequest;
import java.util.Objects;

public class TransferRequest
extends AbstractRaftRequest {
    protected final MemberId member;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected TransferRequest(MemberId member) {
        this.member = member;
    }

    public MemberId member() {
        return this.member;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (this.getClass().isAssignableFrom(object.getClass())) {
            return ((ConfigurationRequest)object).member.equals(this.member);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("member", (Object)this.member).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, TransferRequest> {
        protected MemberId member;

        public Builder withMember(MemberId member) {
            this.member = (MemberId)Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull((Object)this.member, (Object)"member cannot be null");
        }

        public TransferRequest build() {
            return new TransferRequest(this.member);
        }
    }
}

