/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import io.atomix.protocols.raft.service.ServiceRevision;
import io.atomix.protocols.raft.service.impl.DefaultServiceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RaftServiceRegistry
implements Iterable<DefaultServiceContext> {
    private final Map<String, List<DefaultServiceContext>> services = new ConcurrentHashMap<String, List<DefaultServiceContext>>();

    public void registerService(DefaultServiceContext service) {
        List revisions = this.services.computeIfAbsent(service.serviceName(), name -> new CopyOnWriteArrayList());
        revisions.removeIf(revision -> revision.revision().revision() == service.revision().revision());
        revisions.add(service);
    }

    public DefaultServiceContext getRevision(String name, ServiceRevision revision) {
        List<DefaultServiceContext> revisions = this.services.get(name);
        return revisions != null ? (DefaultServiceContext)revisions.stream().filter(s -> s.revision().revision() == revision.revision()).findFirst().orElse(null) : null;
    }

    public DefaultServiceContext getCurrentRevision(String name) {
        List<DefaultServiceContext> revisions = this.services.get(name);
        return revisions != null && !revisions.isEmpty() ? revisions.get(revisions.size() - 1) : null;
    }

    public DefaultServiceContext getPreviousRevision(String name, ServiceRevision revision) {
        List<DefaultServiceContext> revisions = this.services.get(name);
        for (int i = 0; i < revisions.size(); ++i) {
            DefaultServiceContext service = revisions.get(i);
            if (service.revision().revision() != revision.revision()) continue;
            if (i > 0) {
                return revisions.get(i - 1);
            }
            return null;
        }
        return null;
    }

    public DefaultServiceContext getNextRevision(String name, ServiceRevision revision) {
        List<DefaultServiceContext> revisions = this.services.get(name);
        for (int i = 0; i < revisions.size(); ++i) {
            DefaultServiceContext service = revisions.get(i);
            if (service.revision().revision() != revision.revision()) continue;
            if (i < revisions.size() - 1) {
                return revisions.get(i + 1);
            }
            return null;
        }
        return null;
    }

    public Collection<DefaultServiceContext> getRevisions(String name) {
        List<DefaultServiceContext> revisions = this.services.get(name);
        return revisions != null ? revisions : Collections.emptyList();
    }

    @Override
    public Iterator<DefaultServiceContext> iterator() {
        return this.services.values().stream().flatMap(s -> s.stream()).iterator();
    }
}

