/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.phi.PhiAccrualFailureDetector;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.utils.Quorum;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public final class FollowerRole
extends ActiveRole {
    private final PhiAccrualFailureDetector failureDetector;
    private final Random random = new Random();
    private Scheduled heartbeatTimer;
    private Scheduled heartbeatTimeout;

    public FollowerRole(RaftContext context) {
        super(context);
        this.failureDetector = new PhiAccrualFailureDetector(25, context.getHeartbeatInterval().toMillis() / 2L);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.FOLLOWER;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> open() {
        this.raft.setLastHeartbeatTime();
        return ((CompletableFuture)super.open().thenRun(this::startHeartbeatTimer)).thenApply(v -> this);
    }

    private void startHeartbeatTimer() {
        this.log.trace("Starting heartbeat timer");
        AtomicLong lastHeartbeat = new AtomicLong();
        this.heartbeatTimer = this.raft.getThreadContext().schedule(this.raft.getHeartbeatInterval(), this.raft.getHeartbeatInterval(), () -> {
            if (this.raft.getLastHeartbeatTime() > lastHeartbeat.get()) {
                this.failureDetector.report(this.raft.getLastHeartbeatTime());
            }
            lastHeartbeat.set(this.raft.getLastHeartbeatTime());
        });
        this.resetHeartbeatTimeout();
    }

    private void resetHeartbeatTimeout() {
        if (this.heartbeatTimeout != null) {
            this.heartbeatTimeout.cancel();
        }
        Duration delay = this.raft.getHeartbeatInterval().dividedBy(2L).plus(Duration.ofMillis(this.random.nextInt((int)this.raft.getHeartbeatInterval().dividedBy(2L).toMillis())));
        this.heartbeatTimeout = this.raft.getThreadContext().schedule(delay, () -> {
            this.heartbeatTimeout = null;
            if (this.isOpen()) {
                if (!(this.raft.getFirstCommitIndex() != 0L && this.raft.getState() != RaftContext.State.READY || System.currentTimeMillis() - this.raft.getLastHeartbeatTime() <= this.raft.getElectionTimeout().toMillis() && !(this.failureDetector.phi() >= (double)this.raft.getElectionThreshold()))) {
                    this.log.debug("Heartbeat timed out in {}", (Object)(System.currentTimeMillis() - this.raft.getLastHeartbeatTime()));
                    this.sendPollRequests();
                } else {
                    this.resetHeartbeatTimeout();
                }
            }
        });
    }

    private void sendPollRequests() {
        AtomicBoolean complete = new AtomicBoolean();
        this.heartbeatTimeout = this.raft.getThreadContext().schedule(this.raft.getElectionTimeout(), () -> {
            this.log.debug("Failed to poll a majority of the cluster in {}", (Object)this.raft.getElectionTimeout());
            complete.set(true);
            this.resetHeartbeatTimeout();
        });
        Set votingMembers = this.raft.getCluster().getActiveMemberStates().stream().map(RaftMemberContext::getMember).collect(Collectors.toSet());
        if (votingMembers.isEmpty()) {
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.CANDIDATE);
            return;
        }
        Quorum quorum = new Quorum(this.raft.getCluster().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.raft.setLeader(null);
                this.raft.transition(RaftServer.Role.CANDIDATE);
            } else {
                this.resetHeartbeatTimeout();
            }
        });
        Indexed lastEntry = this.raft.getLogWriter().getLastEntry();
        long lastTerm = lastEntry != null ? ((RaftLogEntry)lastEntry.entry()).term() : 0L;
        DefaultRaftMember leader = this.raft.getLeader();
        this.log.debug("Polling members {}", votingMembers);
        for (DefaultRaftMember member : votingMembers) {
            this.log.debug("Polling {} for next term {}", (Object)member, (Object)(this.raft.getTerm() + 1L));
            PollRequest request = PollRequest.newBuilder().withTerm(this.raft.getTerm()).withCandidate(this.raft.getCluster().getMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.raft.getProtocol().poll(member.memberId(), request).whenCompleteAsync((response, error) -> {
                this.raft.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.log.warn("{}", (Object)error.getMessage());
                        quorum.fail();
                    } else {
                        if (response.term() > this.raft.getTerm()) {
                            this.raft.setTerm(response.term());
                        }
                        if (!response.accepted()) {
                            this.log.debug("Received rejected poll from {}", (Object)member);
                            if (leader != null && response.term() == this.raft.getTerm() && member.memberId().equals(leader.memberId())) {
                                quorum.cancel();
                                this.resetHeartbeatTimeout();
                            } else {
                                quorum.fail();
                            }
                        } else if (response.term() != this.raft.getTerm()) {
                            this.log.debug("Received accepted poll for a different term from {}", (Object)member);
                            quorum.fail();
                        } else {
                            this.log.debug("Received accepted poll from {}", (Object)member);
                            quorum.succeed();
                        }
                    }
                }
            }, (Executor)this.raft.getThreadContext());
        }
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.raft.setLastHeartbeatTime();
        }
        return response;
    }

    private void cancelHeartbeatTimers() {
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel();
        }
        if (this.heartbeatTimeout != null) {
            this.log.trace("Cancelling heartbeat timer");
            this.heartbeatTimeout.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelHeartbeatTimers);
    }
}

