/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.AbstractRaftResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Objects;

public class VoteResponse
extends AbstractRaftResponse {
    private final long term;
    private final boolean voted;

    public static Builder newBuilder() {
        return new Builder();
    }

    public VoteResponse(RaftResponse.Status status, RaftError error, long term, boolean voted) {
        super(status, error);
        this.term = term;
        this.voted = voted;
    }

    public long term() {
        return this.term;
    }

    public boolean voted() {
        return this.voted;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.term, this.voted});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof VoteResponse) {
            VoteResponse response = (VoteResponse)object;
            return response.status == this.status && response.term == this.term && response.voted == this.voted;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("term", this.term).add("voted", this.voted).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, VoteResponse> {
        private long term = -1L;
        private boolean voted;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withVoted(boolean voted) {
            this.voted = voted;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            }
        }

        public VoteResponse build() {
            this.validate();
            return new VoteResponse(this.status, this.error, this.term, this.voted);
        }
    }
}

