/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import io.atomix.utils.ArraySizeHashPrinter;
import java.util.Arrays;
import java.util.Objects;

public class InstallRequest
extends AbstractRaftRequest {
    private final long term;
    private final MemberId leader;
    private final long index;
    private final long timestamp;
    private final int offset;
    private final byte[] data;
    private final boolean complete;

    public static Builder newBuilder() {
        return new Builder();
    }

    public InstallRequest(long term, MemberId leader, long index, long timestamp, int offset, byte[] data, boolean complete) {
        this.term = term;
        this.leader = leader;
        this.index = index;
        this.timestamp = timestamp;
        this.offset = offset;
        this.data = data;
        this.complete = complete;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return this.leader;
    }

    public long snapshotIndex() {
        return this.index;
    }

    public long snapshotTimestamp() {
        return this.timestamp;
    }

    public int chunkOffset() {
        return this.offset;
    }

    public byte[] data() {
        return this.data;
    }

    public boolean complete() {
        return this.complete;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.leader, this.index, this.offset, this.complete, this.data);
    }

    public boolean equals(Object object) {
        if (object instanceof InstallRequest) {
            InstallRequest request = (InstallRequest)object;
            return request.term == this.term && request.leader == this.leader && request.index == this.index && request.offset == this.offset && request.complete == this.complete && Arrays.equals(request.data, this.data);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("leader", (Object)this.leader).add("index", this.index).add("offset", this.offset).add("data", (Object)ArraySizeHashPrinter.of((byte[])this.data)).add("complete", this.complete).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, InstallRequest> {
        private long term;
        private MemberId leader;
        private long index;
        private long timestamp;
        private int offset;
        private byte[] data;
        private boolean complete;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null");
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            this.timestamp = timestamp;
            return this;
        }

        public Builder withOffset(int offset) {
            Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be positive");
            this.offset = offset;
            return this;
        }

        public Builder withData(byte[] data) {
            this.data = (byte[])Preconditions.checkNotNull((Object)data, (Object)"data cannot be null");
            return this;
        }

        public Builder withComplete(boolean complete) {
            this.complete = complete;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.offset >= 0 ? 1 : 0) != 0, (Object)"offset must be positive");
            Preconditions.checkNotNull((Object)this.data, (Object)"data cannot be null");
        }

        public InstallRequest build() {
            this.validate();
            return new InstallRequest(this.term, this.leader, this.index, this.timestamp, this.offset, this.data, this.complete);
        }
    }
}

