/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.HeapBuffer;

public class EphemeralSnapshot
extends Snapshot {
    private final Buffer buffer;

    public EphemeralSnapshot(SnapshotDescriptor descriptor) {
        this((Buffer)HeapBuffer.allocate(), descriptor);
    }

    public EphemeralSnapshot(Buffer buffer, SnapshotDescriptor descriptor) {
        super(descriptor);
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
    }

    @Override
    public SnapshotWriter openWriter() {
        return new SnapshotWriter(this.buffer, this);
    }

    @Override
    public SnapshotReader openReader() {
        return new SnapshotReader(this.buffer, this);
    }

    @Override
    public boolean isPersisted() {
        return false;
    }

    @Override
    public Snapshot complete() {
        this.buffer.flip();
        return this;
    }
}

