/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public final class MemberSelector
implements Iterator<MemberId>,
AutoCloseable {
    private final MemberSelectorManager selectors;
    private MemberId leader;
    private Collection<MemberId> servers = new LinkedList<MemberId>();
    private volatile MemberId selection;
    private final CommunicationStrategy strategy;
    private Collection<MemberId> selections = new LinkedList<MemberId>();
    private Iterator<MemberId> selectionsIterator;

    public MemberSelector(MemberId leader, Collection<MemberId> servers, CommunicationStrategy strategy, MemberSelectorManager selectors) {
        this.leader = leader;
        this.servers = (Collection)Preconditions.checkNotNull(servers, (Object)"servers cannot be null");
        this.strategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)strategy), (Object)"strategy cannot be null"));
        this.selectors = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectors, (Object)"selectors cannot be null");
        this.selections = strategy.selectConnections(leader, new ArrayList<MemberId>(servers));
    }

    public State state() {
        if (this.selectionsIterator == null) {
            return State.RESET;
        }
        if (this.hasNext()) {
            return State.ITERATE;
        }
        return State.COMPLETE;
    }

    public MemberId current() {
        return this.selection;
    }

    public MemberId leader() {
        return this.leader;
    }

    public Collection<MemberId> servers() {
        return this.servers;
    }

    public MemberSelector reset() {
        if (this.selectionsIterator != null) {
            this.selections = this.strategy.selectConnections(this.leader, new ArrayList<MemberId>(this.servers));
            this.selectionsIterator = null;
        }
        return this;
    }

    public MemberSelector reset(MemberId leader, Collection<MemberId> servers) {
        if (this.changed(leader, servers)) {
            this.leader = leader;
            this.servers = servers;
            this.selections = this.strategy.selectConnections(leader, new ArrayList<MemberId>(servers));
            this.selectionsIterator = null;
        }
        return this;
    }

    private boolean changed(MemberId leader, Collection<MemberId> servers) {
        Preconditions.checkNotNull(servers, (Object)"servers");
        Preconditions.checkArgument((!servers.isEmpty() ? 1 : 0) != 0, (Object)"servers cannot be empty");
        if (this.leader != null && leader == null) {
            return true;
        }
        if (this.leader == null && leader != null) {
            Preconditions.checkArgument((boolean)servers.contains(leader), (Object)"leader must be present in the servers list");
            return true;
        }
        if (this.leader != null && !this.leader.equals(leader)) {
            Preconditions.checkArgument((boolean)servers.contains(leader), (Object)"leader must be present in the servers list");
            return true;
        }
        return !this.matches(this.servers, servers);
    }

    private boolean matches(Collection<MemberId> left, Collection<MemberId> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (MemberId address : left) {
            if (right.contains(address)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.selectionsIterator == null ? !this.selections.isEmpty() : this.selectionsIterator.hasNext();
    }

    @Override
    public MemberId next() {
        MemberId selection;
        if (this.selectionsIterator == null) {
            this.selectionsIterator = this.selections.iterator();
        }
        this.selection = selection = this.selectionsIterator.next();
        return selection;
    }

    @Override
    public void close() {
        this.selectors.remove(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("strategy", (Object)this.strategy).toString();
    }

    public static enum State {
        RESET,
        ITERATE,
        COMPLETE;

    }
}

