/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.atomix.protocols.raft.event.EventType;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public class DelegatingRaftProxy
implements RaftProxy {
    private final RaftProxyClient client;
    private final Map<EventType, Map<Object, Consumer<RaftEvent>>> eventTypeListeners = Maps.newConcurrentMap();

    public DelegatingRaftProxy(RaftProxyClient client) {
        this.client = client;
    }

    @Override
    public SessionId sessionId() {
        return this.client.sessionId();
    }

    @Override
    public String name() {
        return this.client.name();
    }

    @Override
    public ServiceType serviceType() {
        return this.client.serviceType();
    }

    @Override
    public RaftProxy.State getState() {
        return this.client.getState();
    }

    @Override
    public void addStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.client.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.client.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<byte[]> execute(RaftOperation operation) {
        return this.client.execute(operation);
    }

    @Override
    public void addEventListener(Consumer<RaftEvent> listener) {
        this.client.addEventListener(listener);
    }

    @Override
    public void removeEventListener(Consumer<RaftEvent> listener) {
        this.client.removeEventListener(listener);
    }

    @Override
    public void addEventListener(EventType eventType, Runnable listener) {
        Consumer<RaftEvent> wrappedListener = e -> {
            if (e.type().equals(eventType)) {
                listener.run();
            }
        };
        this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public void addEventListener(EventType eventType, Consumer<byte[]> listener) {
        Consumer<RaftEvent> wrappedListener = e -> {
            if (e.type().equals(eventType)) {
                listener.accept(e.value());
            }
        };
        this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public <T> void addEventListener(EventType eventType, Function<byte[], T> decoder, Consumer<T> listener) {
        Consumer<RaftEvent> wrappedListener = e -> {
            if (e.type().equals(eventType)) {
                listener.accept(decoder.apply(e.value()));
            }
        };
        this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).put(listener, wrappedListener);
        this.addEventListener(wrappedListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Runnable listener) {
        Consumer eventListener = (Consumer)this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).remove(listener);
        this.removeEventListener(eventListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Consumer listener) {
        Consumer eventListener = (Consumer)this.eventTypeListeners.computeIfAbsent(eventType, e -> Maps.newConcurrentMap()).remove(listener);
        this.removeEventListener(eventListener);
    }

    public CompletableFuture<RaftProxy> open() {
        return this.client.open().thenApply(c -> this);
    }

    public boolean isOpen() {
        return this.client.isOpen();
    }

    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    public boolean isClosed() {
        return this.client.isClosed();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("client", (Object)this.client).toString();
    }
}

