/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy;

import io.atomix.protocols.raft.cluster.MemberId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum CommunicationStrategy {
    ANY{

        @Override
        public List<MemberId> selectConnections(MemberId leader, List<MemberId> servers) {
            Collections.shuffle(servers);
            return servers;
        }
    }
    ,
    LEADER{

        @Override
        public List<MemberId> selectConnections(MemberId leader, List<MemberId> servers) {
            if (leader != null) {
                return Collections.singletonList(leader);
            }
            Collections.shuffle(servers);
            return servers;
        }
    }
    ,
    FOLLOWERS{

        @Override
        public List<MemberId> selectConnections(MemberId leader, List<MemberId> servers) {
            Collections.shuffle(servers);
            if (leader != null && servers.size() > 1) {
                ArrayList<MemberId> results = new ArrayList<MemberId>(servers.size());
                for (MemberId memberId : servers) {
                    if (memberId.equals(leader)) continue;
                    results.add(memberId);
                }
                return results;
            }
            return servers;
        }
    };


    public abstract List<MemberId> selectConnections(MemberId var1, List<MemberId> var2);
}

