/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.operation.OperationType;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.service.RaftService;
import io.atomix.protocols.raft.service.ServiceContext;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.service.impl.DefaultCommit;
import io.atomix.protocols.raft.service.impl.DefaultServiceSessions;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessions;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.time.LogicalClock;
import io.atomix.time.LogicalTimestamp;
import io.atomix.time.WallClock;
import io.atomix.time.WallClockTimestamp;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;

public class DefaultServiceContext
implements ServiceContext {
    private final Logger log;
    private final ServiceId serviceId;
    private final String serviceName;
    private final ServiceType serviceType;
    private final RaftService service;
    private final RaftContext raft;
    private final DefaultServiceSessions sessions;
    private final ThreadContextFactory threadContextFactory;
    private final Map<Long, PendingSnapshot> pendingSnapshots = new ConcurrentSkipListMap<Long, PendingSnapshot>();
    private long snapshotIndex;
    private long currentIndex;
    private long currentTimestamp;
    private OperationType currentOperation;
    private final LogicalClock logicalClock = new LogicalClock(){

        public LogicalTimestamp getTime() {
            return new LogicalTimestamp(DefaultServiceContext.this.currentIndex);
        }
    };
    private final WallClock wallClock = new WallClock(){

        public WallClockTimestamp getTime() {
            return new WallClockTimestamp(DefaultServiceContext.this.currentTimestamp);
        }
    };

    public DefaultServiceContext(ServiceId serviceId, String serviceName, ServiceType serviceType, RaftService service, RaftContext raft, ThreadContextFactory threadContextFactory) {
        this.serviceId = (ServiceId)((Object)Preconditions.checkNotNull((Object)((Object)serviceId)));
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName);
        this.serviceType = (ServiceType)Preconditions.checkNotNull((Object)serviceType);
        this.service = (RaftService)Preconditions.checkNotNull((Object)service);
        this.raft = (RaftContext)Preconditions.checkNotNull((Object)raft);
        this.sessions = new DefaultServiceSessions(serviceId, raft.getSessions());
        this.threadContextFactory = threadContextFactory;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftService.class).addValue((Object)serviceId).add("type", (Object)serviceType).add("name", (Object)serviceName).build());
        this.init();
    }

    private void init() {
        this.sessions.addListener(this.service);
        this.service.init(this);
    }

    @Override
    public ServiceId serviceId() {
        return this.serviceId;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Override
    public long currentIndex() {
        return this.currentIndex;
    }

    @Override
    public OperationType currentOperation() {
        return this.currentOperation;
    }

    @Override
    public LogicalClock logicalClock() {
        return this.logicalClock;
    }

    @Override
    public WallClock wallClock() {
        return this.wallClock;
    }

    @Override
    public RaftSessions sessions() {
        return this.sessions;
    }

    private void setOperation(OperationType operation) {
        this.currentOperation = operation;
    }

    private void tick(long index, long timestamp) {
        this.currentIndex = index;
        this.currentTimestamp = Math.max(this.currentTimestamp, timestamp);
        this.setOperation(OperationType.COMMAND);
        this.service.tick(WallClockTimestamp.from((long)timestamp));
    }

    private void expireSessions(long timestamp) {
        for (RaftSessionContext session : this.sessions.getSessions()) {
            if (!session.isTimedOut(timestamp)) continue;
            this.log.debug("Session expired in {} milliseconds: {}", (Object)(timestamp - session.getLastUpdated()), (Object)session);
            this.sessions.expireSession(session);
        }
    }

    public void installSnapshot(SnapshotReader reader) {
        this.log.debug("Installing snapshot {}", (Object)reader.snapshot().index());
        reader.skip(8);
        ServiceType serviceType = ServiceType.from(reader.readString());
        String serviceName = reader.readString();
        int sessionCount = reader.readInt();
        for (int i = 0; i < sessionCount; ++i) {
            SessionId sessionId = SessionId.from(reader.readLong());
            MemberId node = MemberId.from(reader.readString());
            ReadConsistency readConsistency = ReadConsistency.valueOf(reader.readString());
            long minTimeout = reader.readLong();
            long maxTimeout = reader.readLong();
            long sessionTimestamp = reader.readLong();
            RaftSessionContext session = this.sessions.addSession(new RaftSessionContext(sessionId, node, serviceName, serviceType, readConsistency, minTimeout, maxTimeout, sessionTimestamp, this, this.raft, this.threadContextFactory));
            session.setRequestSequence(reader.readLong());
            session.setCommandSequence(reader.readLong());
            session.setEventIndex(reader.readLong());
            session.setLastCompleted(reader.readLong());
            session.setLastApplied(reader.snapshot().index());
            session.setLastUpdated(sessionTimestamp);
            this.sessions.openSession(session);
        }
        this.currentIndex = reader.snapshot().index();
        this.currentTimestamp = reader.snapshot().timestamp().unixTimestamp();
        this.service.install(reader);
    }

    public void takeSnapshot(SnapshotWriter writer) {
        this.log.debug("Taking snapshot {}", (Object)writer.snapshot().index());
        writer.writeLong((Long)this.serviceId.id());
        writer.writeString((String)((Object)this.serviceType.id()));
        writer.writeString(this.serviceName);
        writer.writeInt(this.sessions.getSessions().size());
        for (RaftSessionContext session : this.sessions.getSessions()) {
            writer.writeLong((Long)session.sessionId().id());
            writer.writeString((String)((Object)session.memberId().id()));
            writer.writeString(session.readConsistency().name());
            writer.writeLong(session.minTimeout());
            writer.writeLong(session.maxTimeout());
            writer.writeLong(session.getLastUpdated());
            writer.writeLong(session.getRequestSequence());
            writer.writeLong(session.getCommandSequence());
            writer.writeLong(session.getEventIndex());
            writer.writeLong(session.getLastCompleted());
        }
        this.service.snapshot(writer);
    }

    public long openSession(long index, long timestamp, RaftSessionContext session) {
        this.log.debug("Opening session {}", (Object)session.sessionId());
        session.setLastUpdated(timestamp);
        this.tick(index, timestamp);
        this.expireSessions(this.currentTimestamp);
        this.sessions.openSession(session);
        this.commit();
        return (Long)session.sessionId().id();
    }

    public boolean keepAlive(long index, long timestamp, RaftSessionContext session, long commandSequence, long eventIndex) {
        this.tick(index, timestamp);
        if (session.getState() != RaftSession.State.CLOSED) {
            session.setLastUpdated(timestamp);
            session.clearResults(commandSequence);
            session.resendEvents(eventIndex);
            session.resetRequestSequence(commandSequence);
            session.setCommandSequence(commandSequence);
            return true;
        }
        return false;
    }

    public void completeKeepAlive(long index, long timestamp) {
        this.tick(index, timestamp);
        this.expireSessions(this.currentTimestamp);
        this.commit();
    }

    public void keepAliveSessions(long index, long timestamp) {
        this.log.debug("Resetting session timeouts");
        this.currentIndex = index;
        this.currentTimestamp = Math.max(this.currentTimestamp, timestamp);
        for (RaftSessionContext session : this.sessions.getSessions()) {
            session.setLastUpdated(timestamp);
        }
    }

    public void closeSession(long index, long timestamp, RaftSessionContext session, boolean expired) {
        this.log.debug("Closing session {}", (Object)session.sessionId());
        session.setLastUpdated(timestamp);
        this.tick(index, timestamp);
        this.expireSessions(this.currentTimestamp);
        if (expired) {
            this.sessions.expireSession(session);
        } else {
            this.sessions.closeSession(session);
        }
        this.commit();
    }

    public OperationResult executeCommand(long index, long sequence, long timestamp, RaftSessionContext session, RaftOperation operation) {
        session.setLastUpdated(timestamp);
        this.tick(index, timestamp);
        if (!session.getState().active()) {
            this.log.warn("Session not open: {}", (Object)session);
            throw new RaftException.UnknownSession("Unknown session: " + (Object)((Object)session.sessionId()), new Object[0]);
        }
        if (sequence > 0L && sequence < session.nextCommandSequence()) {
            this.log.trace("Returning cached result for command with sequence number {} < {}", (Object)sequence, (Object)session.nextCommandSequence());
            return this.sequenceCommand(index, sequence, session);
        }
        return this.applyCommand(index, sequence, timestamp, operation, session);
    }

    private OperationResult sequenceCommand(long index, long sequence, RaftSessionContext session) {
        OperationResult result = session.getResult(sequence);
        if (result == null) {
            this.log.debug("Missing command result at index {}", (Object)index);
        }
        return result;
    }

    private OperationResult applyCommand(long index, long sequence, long timestamp, RaftOperation operation, RaftSessionContext session) {
        OperationResult result;
        DefaultCommit<byte[]> commit = new DefaultCommit<byte[]>(index, operation.id(), operation.value(), session, timestamp);
        long eventIndex = session.getEventIndex();
        try {
            byte[] output = this.service.apply(commit);
            result = OperationResult.succeeded(index, eventIndex, output);
        }
        catch (Exception e) {
            result = OperationResult.failed(index, eventIndex, e);
        }
        this.commit();
        session.registerResult(sequence, result);
        session.setCommandSequence(sequence);
        return result;
    }

    public CompletableFuture<OperationResult> executeQuery(long index, long sequence, long timestamp, RaftSessionContext session, RaftOperation operation) {
        CompletableFuture<OperationResult> future = new CompletableFuture<OperationResult>();
        this.executeQuery(index, sequence, timestamp, session, operation, future);
        return future;
    }

    private void executeQuery(long index, long sequence, long timestamp, RaftSessionContext session, RaftOperation operation, CompletableFuture<OperationResult> future) {
        if (!session.getState().active()) {
            this.log.warn("Inactive session: " + (Object)((Object)session.sessionId()));
            future.completeExceptionally(new RaftException.UnknownSession("Unknown session: " + (Object)((Object)session.sessionId()), new Object[0]));
            return;
        }
        this.sequenceQuery(index, sequence, timestamp, session, operation, future);
    }

    private void sequenceQuery(long index, long sequence, long timestamp, RaftSessionContext session, RaftOperation operation, CompletableFuture<OperationResult> future) {
        long commandSequence = session.getCommandSequence();
        if (sequence > commandSequence) {
            this.log.trace("Registering query with sequence number " + sequence + " > " + commandSequence);
            session.registerSequenceQuery(sequence, () -> this.indexQuery(index, timestamp, session, operation, future));
        } else {
            this.indexQuery(index, timestamp, session, operation, future);
        }
    }

    private void indexQuery(long index, long timestamp, RaftSessionContext session, RaftOperation operation, CompletableFuture<OperationResult> future) {
        if (index > this.currentIndex) {
            this.log.trace("Registering query with index " + index + " > " + this.currentIndex);
            session.registerIndexQuery(index, () -> this.applyQuery(timestamp, session, operation, future));
        } else {
            this.applyQuery(timestamp, session, operation, future);
        }
    }

    private void applyQuery(long timestamp, RaftSessionContext session, RaftOperation operation, CompletableFuture<OperationResult> future) {
        OperationResult result;
        if (!session.getState().active()) {
            this.log.warn("Inactive session: " + (Object)((Object)session.sessionId()));
            future.completeExceptionally(new RaftException.UnknownSession("Unknown session: " + (Object)((Object)session.sessionId()), new Object[0]));
            return;
        }
        this.setOperation(OperationType.QUERY);
        DefaultCommit<byte[]> commit = new DefaultCommit<byte[]>(this.currentIndex, operation.id(), operation.value(), session, timestamp);
        long eventIndex = session.getEventIndex();
        try {
            result = OperationResult.succeeded(this.currentIndex, eventIndex, this.service.apply(commit));
        }
        catch (Exception e) {
            result = OperationResult.failed(this.currentIndex, eventIndex, e);
        }
        future.complete(result);
    }

    private void commit() {
        long index = this.currentIndex;
        for (RaftSessionContext session : this.sessions.getSessions()) {
            session.commit(index);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.raft.getName()).add("type", (Object)this.serviceType).add("name", (Object)this.serviceName).add("id", (Object)this.serviceId).toString();
    }

    private class PendingSnapshot {
        private volatile Snapshot snapshot;
        private final CompletableFuture<Long> future = new CompletableFuture();

        public PendingSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        void persist() {
            this.snapshot = this.snapshot.persist();
        }
    }
}

