/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.protocol.OperationRequest;
import java.util.Objects;

public class QueryRequest
extends OperationRequest {
    private final long index;

    public static Builder newBuilder() {
        return new Builder();
    }

    public QueryRequest(long session, long sequence, RaftOperation operation, long index) {
        super(session, sequence, operation);
        this.index = index;
    }

    public long index() {
        return this.index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.sequence, this.operation, this.index);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof QueryRequest) {
            QueryRequest request = (QueryRequest)object;
            return request.session == this.session && request.sequence == this.sequence && request.operation.equals(this.operation);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.session).add("sequence", this.sequence).add("operation", (Object)this.operation).add("index", this.index).toString();
    }

    public static class Builder
    extends OperationRequest.Builder<Builder, QueryRequest> {
        private long index;

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
        }

        public QueryRequest build() {
            this.validate();
            return new QueryRequest(this.session, this.sequence, this.operation, this.index);
        }
    }
}

