/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.raft.operation.OperationId;
import io.atomix.protocols.raft.service.Commit;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.time.LogicalTimestamp;
import io.atomix.time.WallClockTimestamp;
import io.atomix.utils.ArraySizeHashPrinter;
import java.util.Objects;
import java.util.function.Function;

public class DefaultCommit<T>
implements Commit<T> {
    private final long index;
    private final RaftSession session;
    private final long timestamp;
    private final OperationId operation;
    private final T value;

    public DefaultCommit(long index, OperationId operation, T value, RaftSession session, long timestamp) {
        this.index = index;
        this.session = session;
        this.timestamp = timestamp;
        this.operation = operation;
        this.value = value;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public RaftSession session() {
        return this.session;
    }

    @Override
    public LogicalTimestamp logicalTime() {
        return LogicalTimestamp.of((long)this.index);
    }

    @Override
    public WallClockTimestamp wallClockTime() {
        return WallClockTimestamp.from((long)this.timestamp);
    }

    @Override
    public OperationId operation() {
        return this.operation;
    }

    @Override
    public T value() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Commit.class, this.index, this.session.sessionId(), this.operation});
    }

    @Override
    public <U> Commit<U> map(Function<T, U> transcoder) {
        return new DefaultCommit<U>(this.index, this.operation, transcoder.apply(this.value), this.session, this.timestamp);
    }

    @Override
    public Commit<Void> mapToNull() {
        return new DefaultCommit<Object>(this.index, this.operation, null, this.session, this.timestamp);
    }

    public boolean equals(Object object) {
        if (object instanceof Commit) {
            Commit commit = (Commit)object;
            return commit.index() == this.index && commit.session().equals(this.session) && commit.operation().equals(this.operation) && Objects.equals(commit.value(), this.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("session", (Object)this.session).add("time", (Object)this.wallClockTime()).add("operation", (Object)this.operation).add("value", this.value instanceof byte[] ? ArraySizeHashPrinter.of((byte[])((byte[])this.value)) : this.value).toString();
    }
}

