/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.annotations.VisibleForTesting;
import io.atomix.protocols.raft.protocol.OperationResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.impl.RaftProxyState;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;

final class RaftProxySequencer {
    private final Logger log;
    private final RaftProxyState state;
    @VisibleForTesting
    long requestSequence;
    @VisibleForTesting
    long responseSequence;
    @VisibleForTesting
    long eventIndex;
    private final Queue<EventCallback> eventCallbacks = new ArrayDeque<EventCallback>();
    private final Map<Long, ResponseCallback> responseCallbacks = new HashMap<Long, ResponseCallback>();

    RaftProxySequencer(RaftProxyState state) {
        this.state = state;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftProxy.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getServiceType()).add("name", (Object)state.getServiceName()).build());
    }

    public long nextRequest() {
        return ++this.requestSequence;
    }

    public void sequenceEvent(PublishRequest request, Runnable callback) {
        if (this.requestSequence == this.responseSequence) {
            this.log.trace("Completing {}", (Object)request);
            callback.run();
            this.eventIndex = request.eventIndex();
        } else {
            this.eventCallbacks.add(new EventCallback(request, callback));
            this.completeResponses();
        }
    }

    public void sequenceResponse(long sequence, OperationResponse response, Runnable callback) {
        if (sequence == this.responseSequence + 1L) {
            if (this.completeResponse(response, callback)) {
                ++this.responseSequence;
                this.completeResponses();
            } else {
                this.responseCallbacks.put(sequence, new ResponseCallback(response, callback));
            }
        } else if (sequence > this.responseSequence) {
            this.responseCallbacks.put(sequence, new ResponseCallback(response, callback));
        }
    }

    private void completeResponses() {
        ResponseCallback response = this.responseCallbacks.get(this.responseSequence + 1L);
        while (response != null && this.completeResponse(response.response, response.callback)) {
            this.responseCallbacks.remove(++this.responseSequence);
            response = this.responseCallbacks.get(this.responseSequence + 1L);
        }
        if (this.requestSequence == this.responseSequence) {
            EventCallback eventCallback = this.eventCallbacks.poll();
            while (eventCallback != null) {
                this.log.trace("Completing {}", (Object)eventCallback.request);
                eventCallback.run();
                this.eventIndex = eventCallback.request.eventIndex();
                eventCallback = this.eventCallbacks.poll();
            }
        }
    }

    private boolean completeResponse(OperationResponse response, Runnable callback) {
        if (response == null) {
            this.log.trace("Completing failed request");
            callback.run();
            return true;
        }
        if (response.eventIndex() > this.eventIndex) {
            EventCallback eventCallback = this.eventCallbacks.peek();
            while (eventCallback != null && eventCallback.request.eventIndex() <= response.eventIndex()) {
                this.eventCallbacks.remove();
                this.log.trace("Completing event {}", (Object)eventCallback.request);
                eventCallback.run();
                this.eventIndex = eventCallback.request.eventIndex();
                eventCallback = this.eventCallbacks.peek();
            }
        }
        if (response.eventIndex() <= this.eventIndex || this.eventIndex == 0L && response.eventIndex() == ((Long)this.state.getSessionId().id()).longValue()) {
            this.log.trace("Completing response {}", (Object)response);
            callback.run();
            return true;
        }
        return false;
    }

    private static final class EventCallback
    implements Runnable {
        private final PublishRequest request;
        private final Runnable callback;

        private EventCallback(PublishRequest request, Runnable callback) {
            this.request = request;
            this.callback = callback;
        }

        @Override
        public void run() {
            this.callback.run();
        }
    }

    private static final class ResponseCallback
    implements Runnable {
        private final OperationResponse response;
        private final Runnable callback;

        private ResponseCallback(OperationResponse response, Runnable callback) {
            this.response = response;
            this.callback = callback;
        }

        @Override
        public void run() {
            this.callback.run();
        }
    }
}

