/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Collection;
import java.util.Objects;

public class ConfigureRequest
extends AbstractRaftRequest {
    private final long term;
    private final String leader;
    private final long index;
    private final long timestamp;
    private final Collection<RaftMember> members;

    public static Builder newBuilder() {
        return new Builder();
    }

    public ConfigureRequest(long term, String leader, long index, long timestamp, Collection<RaftMember> members) {
        this.term = term;
        this.leader = leader;
        this.index = index;
        this.timestamp = timestamp;
        this.members = members;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return MemberId.from(this.leader);
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<RaftMember> members() {
        return this.members;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.leader, this.index, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigureRequest) {
            ConfigureRequest request = (ConfigureRequest)object;
            return request.term == this.term && request.leader == this.leader && request.index == this.index && request.timestamp == this.timestamp && request.members.equals(this.members);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("leader", (Object)this.leader).add("index", this.index).add("timestamp", this.timestamp).add("members", this.members).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, ConfigureRequest> {
        private long term;
        private String leader;
        private long index;
        private long timestamp;
        private Collection<RaftMember> members;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null")).id());
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTime(long timestamp) {
            Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            this.timestamp = timestamp;
            return this;
        }

        public Builder withMembers(Collection<RaftMember> members) {
            this.members = (Collection)Preconditions.checkNotNull(members, (Object)"members cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
        }

        public ConfigureRequest build() {
            this.validate();
            return new ConfigureRequest(this.term, this.leader, this.index, this.timestamp, this.members);
        }
    }
}

