/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import java.util.Objects;

public final class RaftSessionMetadata {
    private final long id;
    private final String name;
    private final String type;

    public RaftSessionMetadata(long id, String name, String type) {
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
    }

    public SessionId sessionId() {
        return SessionId.from(this.id);
    }

    public String serviceName() {
        return this.name;
    }

    public ServiceType serviceType() {
        return ServiceType.from(this.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.name);
    }

    public boolean equals(Object object) {
        if (object instanceof RaftSessionMetadata) {
            RaftSessionMetadata metadata = (RaftSessionMetadata)object;
            return metadata.id == this.id && Objects.equals(metadata.name, this.name) && Objects.equals(metadata.type, this.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("type", (Object)this.type).toString();
    }
}

