/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import com.google.common.collect.Sets;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionListener;
import io.atomix.protocols.raft.session.RaftSessions;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.session.impl.RaftSessionRegistry;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

class DefaultServiceSessions
implements RaftSessions {
    private final ServiceId serviceId;
    private final Set<RaftSessionListener> listeners = Sets.newIdentityHashSet();
    private final RaftSessionRegistry sessionManager;

    public DefaultServiceSessions(ServiceId serviceId, RaftSessionRegistry sessionManager) {
        this.serviceId = serviceId;
        this.sessionManager = sessionManager;
    }

    void openSession(RaftSessionContext session) {
        session.open();
        this.sessionManager.addSession(session);
        this.listeners.forEach(l -> l.onOpen(session));
    }

    void expireSession(RaftSessionContext session) {
        session.expire();
        this.sessionManager.removeSession(session.sessionId());
        this.listeners.forEach(l -> l.onExpire(session));
    }

    void closeSession(RaftSessionContext session) {
        session.close();
        this.sessionManager.removeSession(session.sessionId());
        this.listeners.forEach(l -> l.onClose(session));
    }

    Collection<RaftSessionContext> getSessions() {
        return this.sessionManager.getSessions(this.serviceId);
    }

    @Override
    public RaftSession getSession(long sessionId) {
        RaftSessionContext session = this.sessionManager.getSession(sessionId);
        return session != null && session.getState().active() ? session : null;
    }

    @Override
    public RaftSessions addListener(RaftSessionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public RaftSessions removeListener(RaftSessionListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public Iterator<RaftSession> iterator() {
        return this.getSessions().iterator();
    }
}

