/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxyConnection;
import io.atomix.protocols.raft.proxy.impl.RaftProxyInvoker;
import io.atomix.protocols.raft.proxy.impl.RaftProxyListener;
import io.atomix.protocols.raft.proxy.impl.RaftProxyManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxySequencer;
import io.atomix.protocols.raft.proxy.impl.RaftProxyState;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DiscreteRaftProxyClient
implements RaftProxyClient {
    private final RaftProxyState state;
    private final RaftProxyManager sessionManager;
    private final RaftProxyListener proxyListener;
    private final RaftProxyInvoker proxySubmitter;

    public DiscreteRaftProxyClient(RaftProxyState state, RaftClientProtocol protocol, MemberSelectorManager selectorManager, RaftProxyManager sessionManager, CommunicationStrategy communicationStrategy, ThreadContext context) {
        this.state = (RaftProxyState)Preconditions.checkNotNull((Object)state, (Object)"state cannot be null");
        this.sessionManager = (RaftProxyManager)Preconditions.checkNotNull((Object)sessionManager, (Object)"sessionManager cannot be null");
        RaftProxyConnection leaderConnection = new RaftProxyConnection(protocol, selectorManager.createSelector(CommunicationStrategy.LEADER), context, LoggerContext.builder(RaftProxy.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getServiceType()).add("name", (Object)state.getServiceName()).build());
        RaftProxyConnection sessionConnection = new RaftProxyConnection(protocol, selectorManager.createSelector(communicationStrategy), context, LoggerContext.builder(RaftProxy.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getServiceType()).add("name", (Object)state.getServiceName()).build());
        RaftProxySequencer sequencer = new RaftProxySequencer(state);
        this.proxyListener = new RaftProxyListener(protocol, selectorManager.createSelector(CommunicationStrategy.ANY), state, sequencer, (Executor)context);
        this.proxySubmitter = new RaftProxyInvoker(leaderConnection, sessionConnection, state, sequencer, sessionManager, context);
    }

    @Override
    public String name() {
        return this.state.getServiceName();
    }

    @Override
    public ServiceType serviceType() {
        return this.state.getServiceType();
    }

    @Override
    public SessionId sessionId() {
        return this.state.getSessionId();
    }

    @Override
    public RaftProxy.State getState() {
        return this.state.getState();
    }

    @Override
    public void addStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.state.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.state.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<byte[]> execute(RaftOperation operation) {
        return this.proxySubmitter.invoke(operation);
    }

    @Override
    public void addEventListener(Consumer<RaftEvent> listener) {
        this.proxyListener.addEventListener(listener);
    }

    @Override
    public void removeEventListener(Consumer<RaftEvent> listener) {
        this.proxyListener.removeEventListener(listener);
    }

    public CompletableFuture<RaftProxyClient> open() {
        return CompletableFuture.completedFuture(this);
    }

    public boolean isOpen() {
        return this.state.getState() != RaftProxy.State.CLOSED;
    }

    public CompletableFuture<Void> close() {
        return this.sessionManager.closeSession(this.state.getSessionId()).whenComplete((result, error) -> this.state.setState(RaftProxy.State.CLOSED));
    }

    public boolean isClosed() {
        return this.state.getState() == RaftProxy.State.CLOSED;
    }

    public int hashCode() {
        int hashCode = 31;
        long id = (Long)this.state.getSessionId().id();
        hashCode = 37 * hashCode + (int)(id ^ id >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof DiscreteRaftProxyClient && ((DiscreteRaftProxyClient)object).state.getSessionId() == this.state.getSessionId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.state.getSessionId()).toString();
    }
}

