/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session;

import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.event.EventType;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.RaftSessionEventListener;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.storage.buffer.HeapBytes;
import java.util.function.Function;

public interface RaftSession {
    public SessionId sessionId();

    public String serviceName();

    public ServiceType serviceType();

    public MemberId memberId();

    public ReadConsistency readConsistency();

    public long timeout();

    public State getState();

    public void addListener(RaftSessionEventListener var1);

    public void removeListener(RaftSessionEventListener var1);

    default public void publish(EventType eventType) {
        this.publish(new RaftEvent(eventType, HeapBytes.EMPTY));
    }

    default public <T> void publish(EventType eventType, Function<T, byte[]> encoder, T event) {
        this.publish(eventType, encoder.apply(event));
    }

    default public void publish(EventType eventType, byte[] event) {
        this.publish(new RaftEvent(eventType, event));
    }

    public void publish(RaftEvent var1);

    public static enum State {
        OPEN(true),
        SUSPICIOUS(true),
        EXPIRED(false),
        CLOSED(false);

        private final boolean active;

        private State(boolean active) {
            this.active = active;
        }

        public boolean active() {
            return this.active;
        }
    }
}

