/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.time.WallClockTimestamp;

public abstract class Snapshot
implements AutoCloseable {
    private final SnapshotStore store;
    private SnapshotWriter writer;

    protected Snapshot(SnapshotStore store) {
        this.store = (SnapshotStore)Preconditions.checkNotNull((Object)store, (Object)"store cannot be null");
    }

    public abstract ServiceId serviceId();

    public abstract long index();

    public abstract WallClockTimestamp timestamp();

    public abstract SnapshotWriter openWriter();

    protected void checkWriter() {
        Preconditions.checkState((this.writer == null ? 1 : 0) != 0, (Object)"cannot create multiple writers for the same snapshot");
    }

    protected SnapshotWriter openWriter(SnapshotWriter writer, SnapshotDescriptor descriptor) {
        this.checkWriter();
        Preconditions.checkState((!descriptor.isLocked() ? 1 : 0) != 0, (Object)"cannot write to locked snapshot descriptor");
        this.writer = (SnapshotWriter)Preconditions.checkNotNull((Object)writer, (Object)"writer cannot be null");
        return writer;
    }

    protected void closeWriter(SnapshotWriter writer) {
        this.writer = null;
    }

    public abstract SnapshotReader openReader();

    protected SnapshotReader openReader(SnapshotReader reader, SnapshotDescriptor descriptor) {
        Preconditions.checkState((boolean)descriptor.isLocked(), (Object)"cannot read from unlocked snapshot descriptor");
        return reader;
    }

    protected void closeReader(SnapshotReader reader) {
        reader = null;
    }

    public Snapshot complete() {
        this.store.completeSnapshot(this);
        return this;
    }

    public Snapshot persist() {
        return this;
    }

    public abstract boolean isPersisted();

    @Override
    public void close() {
    }

    public void delete() {
    }
}

