/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import io.atomix.utils.ArraySizeHashPrinter;

public final class OperationResult {
    private final long index;
    private final long eventIndex;
    private final Throwable error;
    private final byte[] result;

    public static OperationResult noop(long index, long eventIndex) {
        return new OperationResult(index, eventIndex, null, null);
    }

    public static OperationResult succeeded(long index, long eventIndex, byte[] result) {
        return new OperationResult(index, eventIndex, null, result);
    }

    public static OperationResult failed(long index, long eventIndex, Throwable error) {
        return new OperationResult(index, eventIndex, error, null);
    }

    private OperationResult(long index, long eventIndex, Throwable error, byte[] result) {
        this.index = index;
        this.eventIndex = eventIndex;
        this.error = error;
        this.result = result;
    }

    public long index() {
        return this.index;
    }

    public long eventIndex() {
        return this.eventIndex;
    }

    public Throwable error() {
        return this.error;
    }

    public byte[] result() {
        return this.result;
    }

    public boolean succeeded() {
        return this.error == null;
    }

    public boolean failed() {
        return !this.succeeded();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("eventIndex", this.eventIndex).add("error", (Object)this.error).add("result", (Object)ArraySizeHashPrinter.of((byte[])this.result)).toString();
    }
}

