/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.utils.event.AbstractEvent;
import io.atomix.utils.misc.TimestampPrinter;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class PartitionEvent
extends AbstractEvent<Type, PartitionId> {
    private final Collection<MemberId> members;
    private final MemberId primary;
    private final Collection<MemberId> backups;

    public PartitionEvent(Type type, PartitionId partition, Collection<MemberId> members, MemberId primary, Collection<MemberId> backups) {
        this(type, partition, members, primary, backups, System.currentTimeMillis());
    }

    public PartitionEvent(Type type, PartitionId partition, Collection<MemberId> members, MemberId primary, Collection<MemberId> backups, long time) {
        super((Enum)type, (Object)partition, time);
        this.members = (Collection)Preconditions.checkNotNull(members);
        this.primary = primary;
        this.backups = (Collection)Preconditions.checkNotNull(backups);
    }

    public PartitionId partitionId() {
        return (PartitionId)this.subject();
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public Optional<MemberId> primary() {
        return Optional.ofNullable(this.primary);
    }

    public Collection<MemberId> backups() {
        return this.backups;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId(), this.members(), this.primary(), this.backups());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PartitionEvent) {
            PartitionEvent that = (PartitionEvent)((Object)object);
            return this.partitionId().equals(that.partitionId()) && this.members.equals(that.members) && Objects.equals(this.primary, that.primary) && this.backups.equals(that.backups);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("time", (Object)new TimestampPrinter(this.time())).add("type", (Object)this.type()).add("partitionId", this.subject()).add("members", this.members).add("primary", (Object)this.primary).add("backups", this.backups).toString();
    }

    public static enum Type {
        PRIMARY_CHANGED,
        BACKUPS_CHANGED,
        MEMBERS_CHANGED;

    }
}

