/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxySession;
import io.atomix.primitive.proxy.impl.AbstractProxyClient;
import io.atomix.primitive.proxy.impl.DefaultProxySession;
import io.atomix.primitive.session.SessionClient;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultProxyClient<S>
extends AbstractProxyClient<S> {
    private final Partitioner<String> partitioner;
    private final Serializer serializer;

    public DefaultProxyClient(String name, PrimitiveType type, PrimitiveProtocol protocol, Class<S> serviceType, Collection<SessionClient> partitions, Partitioner<String> partitioner) {
        super(name, type, protocol, DefaultProxyClient.createSessions(type, serviceType, partitions));
        this.partitioner = (Partitioner)Preconditions.checkNotNull(partitioner);
        this.serializer = Serializer.using((Namespace)type.namespace());
    }

    private static <S> Collection<ProxySession<S>> createSessions(PrimitiveType primitiveType, Class<S> serviceType, Collection<SessionClient> partitions) {
        Serializer serializer = Serializer.using((Namespace)primitiveType.namespace());
        return partitions.stream().map(partition -> new DefaultProxySession((SessionClient)partition, serviceType, serializer)).collect(Collectors.toList());
    }

    @Override
    public PartitionId getPartitionId(String key) {
        return this.partitioner.partition(key, (List<PartitionId>)this.getPartitionIds());
    }

    @Override
    public PartitionId getPartitionId(Object key) {
        return this.partitioner.partition(BaseEncoding.base16().encode(this.serializer.encode(key)), (List<PartitionId>)this.getPartitionIds());
    }
}

