/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.cluster.Member;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.impl.NodeMemberGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MemberGroupStrategy implements MemberGroupProvider
{
    ZONE_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Member> members) {
            return this.groupNodes(members, node -> node.zone() != null ? node.zone() : (String)((Object)node.id().id()));
        }
    }
    ,
    RACK_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Member> members) {
            return this.groupNodes(members, node -> node.rack() != null ? node.rack() : (String)((Object)node.id().id()));
        }
    }
    ,
    HOST_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Member> members) {
            return this.groupNodes(members, node -> node.host() != null ? node.host() : (String)((Object)node.id().id()));
        }
    }
    ,
    NODE_AWARE{

        @Override
        public Collection<MemberGroup> getMemberGroups(Collection<Member> members) {
            return this.groupNodes(members, node -> (String)((Object)node.id().id()));
        }
    };


    protected Collection<MemberGroup> groupNodes(Collection<Member> members, Function<Member, String> keyFunction) {
        HashMap<String, Set> groups = new HashMap<String, Set>();
        for (Member member : members) {
            groups.computeIfAbsent(keyFunction.apply(member), k -> new HashSet()).add(member);
        }
        return groups.entrySet().stream().map(entry -> new NodeMemberGroup(MemberGroupId.from((String)entry.getKey()), (Set)entry.getValue())).collect(Collectors.toList());
    }
}

