/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.PartitionGroupMembership;
import io.atomix.primitive.partition.PartitionGroupMembershipEvent;
import io.atomix.primitive.partition.PartitionGroupMembershipEventListener;
import io.atomix.primitive.partition.PartitionGroupMembershipService;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEvent;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import io.atomix.utils.event.EventListener;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashBasedPrimaryElection
extends AbstractListenerManager<PrimaryElectionEvent, PrimaryElectionEventListener>
implements PrimaryElection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashBasedPrimaryElection.class);
    private static final long BROADCAST_INTERVAL = 5000L;
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).register(new Class[]{MemberId.class}).register(new Class[]{MemberId.Type.class}).build());
    private final PartitionId partitionId;
    private final ClusterMembershipService clusterMembershipService;
    private final PartitionGroupMembershipService groupMembershipService;
    private final ClusterCommunicationService communicationService;
    private final ClusterMembershipEventListener clusterMembershipEventListener = this::handleClusterMembershipEvent;
    private final Map<MemberId, Integer> counters = Maps.newConcurrentMap();
    private final String subject;
    private final ScheduledFuture<?> broadcastFuture;
    private volatile PrimaryTerm currentTerm;
    private final PartitionGroupMembershipEventListener groupMembershipEventListener = new PartitionGroupMembershipEventListener(){

        public void onEvent(PartitionGroupMembershipEvent event) {
            HashBasedPrimaryElection.this.recomputeTerm(event.membership());
        }

        public boolean isRelevant(PartitionGroupMembershipEvent event) {
            return event.membership().group().equals(HashBasedPrimaryElection.this.partitionId.group());
        }
    };

    public HashBasedPrimaryElection(PartitionId partitionId, ClusterMembershipService clusterMembershipService, PartitionGroupMembershipService groupMembershipService, ClusterCommunicationService communicationService, ScheduledExecutorService executor) {
        this.partitionId = partitionId;
        this.clusterMembershipService = clusterMembershipService;
        this.groupMembershipService = groupMembershipService;
        this.communicationService = communicationService;
        this.subject = String.format("primary-election-counter-%s-%d", partitionId.group(), partitionId.id());
        this.recomputeTerm(groupMembershipService.getMembership(partitionId.group()));
        groupMembershipService.addListener(this.groupMembershipEventListener);
        clusterMembershipService.addListener((EventListener)this.clusterMembershipEventListener);
        communicationService.subscribe(this.subject, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::updateCounters, (Executor)executor);
        this.broadcastFuture = executor.scheduleAtFixedRate(this::broadcastCounters, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<PrimaryTerm> enter(GroupMember member) {
        return CompletableFuture.completedFuture(this.currentTerm);
    }

    @Override
    public CompletableFuture<PrimaryTerm> getTerm() {
        return CompletableFuture.completedFuture(this.currentTerm);
    }

    private void handleClusterMembershipEvent(ClusterMembershipEvent event) {
        if (event.type() == ClusterMembershipEvent.Type.MEMBER_ADDED || event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED) {
            this.recomputeTerm(this.groupMembershipService.getMembership(this.partitionId.group()));
        }
    }

    private long currentTerm() {
        return this.counters.values().stream().mapToInt(v -> v).sum();
    }

    private long incrementTerm() {
        this.counters.compute(this.clusterMembershipService.getLocalMember().id(), (id, value) -> value != null ? value + 1 : 1);
        this.broadcastCounters();
        return this.currentTerm();
    }

    private void updateCounters(Map<MemberId, Integer> counters) {
        for (Map.Entry<MemberId, Integer> entry : counters.entrySet()) {
            this.counters.compute(entry.getKey(), (key, value) -> {
                if (value == null || value < (Integer)entry.getValue()) {
                    return (Integer)entry.getValue();
                }
                return value;
            });
        }
        this.updateTerm(this.currentTerm());
    }

    private void broadcastCounters() {
        this.communicationService.broadcast(this.subject, this.counters, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    private void updateTerm(long term) {
        if (term > this.currentTerm.term()) {
            this.recomputeTerm(this.groupMembershipService.getMembership(this.partitionId.group()));
        }
    }

    private synchronized void recomputeTerm(PartitionGroupMembership membership) {
        if (membership == null) {
            return;
        }
        List<Object> candidates = new ArrayList<GroupMember>();
        for (MemberId memberId : membership.members()) {
            Member member = this.clusterMembershipService.getMember(memberId);
            if (member == null || member.getState() != Member.State.ACTIVE) continue;
            candidates.add(new GroupMember(memberId, MemberGroupId.from((String)((Object)memberId.id()))));
        }
        candidates.sort((a, b) -> {
            int aoffset = Hashing.murmur3_32().hashString((CharSequence)((Object)a.memberId().id()), StandardCharsets.UTF_8).asInt() % (Integer)this.partitionId.id();
            int boffset = Hashing.murmur3_32().hashString((CharSequence)((Object)b.memberId().id()), StandardCharsets.UTF_8).asInt() % (Integer)this.partitionId.id();
            return aoffset - boffset;
        });
        PrimaryTerm currentTerm = this.currentTerm;
        GroupMember primary = candidates.isEmpty() ? null : (GroupMember)candidates.get(0);
        candidates = candidates.isEmpty() ? Collections.emptyList() : candidates.subList(1, candidates.size());
        long term = currentTerm != null && Objects.equals(currentTerm.primary(), primary) && Objects.equals(currentTerm.candidates(), candidates) ? this.currentTerm() : this.incrementTerm();
        PrimaryTerm newTerm = new PrimaryTerm(term, primary, candidates);
        if (!Objects.equals(currentTerm, newTerm)) {
            this.currentTerm = newTerm;
            LOGGER.debug("{} - Recomputed term for partition {}: {}", new Object[]{this.clusterMembershipService.getLocalMember().id(), this.partitionId, newTerm});
            this.post((Event)new PrimaryElectionEvent(PrimaryElectionEvent.Type.CHANGED, this.partitionId, newTerm));
            this.broadcastCounters();
        }
    }

    void close() {
        this.broadcastFuture.cancel(false);
        this.groupMembershipService.removeListener(this.groupMembershipEventListener);
        this.clusterMembershipService.removeListener((EventListener)this.clusterMembershipEventListener);
    }
}

