/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.messaging.ClusterMessagingService;
import io.atomix.primitive.partition.ManagedPrimaryElectionService;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEvent;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryElectionService;
import io.atomix.primitive.partition.impl.HashBasedPrimaryElection;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.serializer.KryoNamespace;
import io.atomix.utils.serializer.KryoNamespaces;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashBasedPrimaryElectionService
extends AbstractListenerManager<PrimaryElectionEvent, PrimaryElectionEventListener>
implements ManagedPrimaryElectionService {
    private static final String SUBJECT = "primary-election-counter";
    private static final long BROADCAST_INTERVAL = 5000L;
    private static final Serializer SERIALIZER = Serializer.using((Namespace)KryoNamespace.builder().register(KryoNamespaces.BASIC).register(new Class[]{NodeId.class}).build());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClusterService clusterService;
    private final ClusterMessagingService messagingService;
    private final Map<PartitionId, PrimaryElection> elections = Maps.newConcurrentMap();
    private final PrimaryElectionEventListener primaryElectionListener = arg_0 -> ((HashBasedPrimaryElectionService)this).post(arg_0);
    private final Map<NodeId, Integer> counters = Maps.newConcurrentMap();
    private final ScheduledExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean();
    private ScheduledFuture<?> broadcastFuture;

    public HashBasedPrimaryElectionService(ClusterService clusterService, ClusterMessagingService messagingService) {
        this.clusterService = clusterService;
        this.messagingService = messagingService;
        this.executor = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"primary-election-%d", (Logger)this.log));
    }

    @Override
    public PrimaryElection getElectionFor(PartitionId partitionId) {
        return this.elections.computeIfAbsent(partitionId, id -> {
            HashBasedPrimaryElection election = new HashBasedPrimaryElection(partitionId, this.clusterService, this);
            election.addListener(this.primaryElectionListener);
            return election;
        });
    }

    long getTerm() {
        return this.counters.values().stream().mapToInt(v -> v).sum();
    }

    long incrementTerm() {
        this.counters.compute(this.clusterService.getLocalNode().id(), (id, value) -> value != null ? value + 1 : 1);
        this.broadcastCounters();
        return this.getTerm();
    }

    private void updateCounters(Map<NodeId, Integer> counters) {
        for (Map.Entry<NodeId, Integer> entry : counters.entrySet()) {
            this.counters.compute(entry.getKey(), (key, value) -> {
                if (value == null || value < (Integer)entry.getValue()) {
                    return (Integer)entry.getValue();
                }
                return value;
            });
        }
    }

    private void broadcastCounters() {
        this.messagingService.broadcast(SUBJECT, this.counters, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    public CompletableFuture<PrimaryElectionService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.messagingService.subscribe(SUBJECT, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::updateCounters, (Executor)this.executor);
            this.broadcastFuture = this.executor.scheduleAtFixedRate(this::broadcastCounters, 5000L, 5000L, TimeUnit.MILLISECONDS);
        }
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.messagingService.unsubscribe(SUBJECT);
            if (this.broadcastFuture != null) {
                this.broadcastFuture.cancel(false);
            }
        }
        return CompletableFuture.completedFuture(null);
    }
}

