/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.hash.Hashing;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;

public interface PartitionGroup<P extends PrimitiveProtocol> {
    public String name();

    public PrimitiveProtocol.Type type();

    public P newProtocol();

    public Partition getPartition(PartitionId var1);

    default public Partition getPartition(String key) {
        int hashCode = Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).asInt();
        return this.getPartition(this.getPartitionIds().get(Math.abs(hashCode) % this.getPartitionIds().size()));
    }

    public Collection<Partition<P>> getPartitions();

    public List<PartitionId> getPartitionIds();

    public static abstract class Builder<C extends PartitionGroupConfig<C>>
    implements io.atomix.utils.Builder<ManagedPartitionGroup> {
        protected final C config;

        protected Builder(C config) {
            this.config = config;
        }
    }
}

