/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import com.google.common.base.Preconditions;
import io.atomix.primitive.Consistency;
import io.atomix.primitive.DistributedPrimitive;
import io.atomix.primitive.Persistence;
import io.atomix.primitive.PrimitiveProtocol;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.utils.Builder;
import io.atomix.utils.serializer.KryoNamespaces;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class DistributedPrimitiveBuilder<B extends DistributedPrimitiveBuilder<B, P>, P extends DistributedPrimitive>
implements Builder<P> {
    private final PrimitiveType type;
    private final String name;
    private Serializer serializer;
    private boolean readOnly = false;
    private boolean relaxedReadConsistency = false;
    private PrimitiveProtocol protocol;
    private Persistence persistence = this.defaultPersistence();
    private Consistency consistency = this.defaultConsistency();
    private Replication replication = this.defaultReplication();
    private Recovery recovery = this.defaultRecovery();
    private int numBackups = 2;
    private int maxRetries;
    private Duration retryDelay = Duration.ofMillis(100L);

    public DistributedPrimitiveBuilder(PrimitiveType type, String name) {
        this.type = (PrimitiveType)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
    }

    public B withSerializer(Serializer serializer) {
        this.serializer = serializer;
        return (B)this;
    }

    public B withUpdatesDisabled() {
        this.readOnly = true;
        return (B)this;
    }

    public B withRelaxedReadConsistency() {
        this.relaxedReadConsistency = true;
        return (B)this;
    }

    public B withProtocol(PrimitiveProtocol protocol) {
        this.protocol = (PrimitiveProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        return (B)this;
    }

    public B withConsistency(Consistency consistency) {
        this.consistency = (Consistency)((Object)Preconditions.checkNotNull((Object)((Object)consistency), (Object)"consistency cannot be null"));
        return (B)this;
    }

    public B withPersistence(Persistence persistence) {
        this.persistence = (Persistence)((Object)Preconditions.checkNotNull((Object)((Object)persistence), (Object)"persistence cannot be null"));
        return (B)this;
    }

    public B withReplication(Replication replication) {
        this.replication = (Replication)((Object)Preconditions.checkNotNull((Object)((Object)replication), (Object)"replication cannot be null"));
        return (B)this;
    }

    public B withRecovery(Recovery recovery) {
        this.recovery = (Recovery)((Object)Preconditions.checkNotNull((Object)((Object)recovery), (Object)"recovery cannot be null"));
        return (B)this;
    }

    public B withBackups(int numBackups) {
        Preconditions.checkArgument((numBackups >= 0 ? 1 : 0) != 0, (Object)"numBackups must be positive");
        this.numBackups = numBackups;
        return (B)this;
    }

    public B withMaxRetries(int maxRetries) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be positive");
        this.maxRetries = maxRetries;
        return (B)this;
    }

    public B withRetryDelay(Duration retryDelay) {
        this.retryDelay = (Duration)Preconditions.checkNotNull((Object)retryDelay, (Object)"retryDelay cannot be null");
        return (B)this;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public boolean relaxedReadConsistency() {
        return this.relaxedReadConsistency;
    }

    public Serializer serializer() {
        if (this.serializer == null) {
            this.serializer = Serializer.using((Namespace)KryoNamespaces.BASIC);
        }
        return this.serializer;
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType primitiveType() {
        return this.type;
    }

    public PrimitiveProtocol protocol() {
        return this.protocol;
    }

    public Consistency consistency() {
        return this.consistency;
    }

    protected abstract Consistency defaultConsistency();

    public Persistence persistence() {
        return this.persistence;
    }

    protected abstract Persistence defaultPersistence();

    public Replication replication() {
        return this.replication;
    }

    public Recovery recovery() {
        return this.recovery;
    }

    protected Recovery defaultRecovery() {
        return Recovery.RECOVER;
    }

    public int backups() {
        return this.numBackups;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public Duration retryDelay() {
        return this.retryDelay;
    }

    protected abstract Replication defaultReplication();

    public P build() {
        return (P)((DistributedPrimitive)this.buildAsync().join());
    }

    public abstract CompletableFuture<P> buildAsync();
}

