/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.proxy;

import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.proxy.PrimitiveProxyExecutor;
import io.atomix.primitive.session.SessionId;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public interface PrimitiveProxy
extends PrimitiveProxyExecutor {
    public SessionId sessionId();

    public String name();

    public PrimitiveType serviceType();

    public State getState();

    default public CompletableFuture<Void> invoke(OperationId operationId) {
        return this.execute(operationId).thenApply(r -> null);
    }

    default public <R> CompletableFuture<R> invoke(OperationId operationId, Function<byte[], R> decoder) {
        return this.execute(operationId).thenApply(decoder);
    }

    default public <T> CompletableFuture<Void> invoke(OperationId operationId, Function<T, byte[]> encoder, T operation) {
        return this.execute(operationId, encoder.apply(operation)).thenApply(r -> null);
    }

    default public <T, R> CompletableFuture<R> invoke(OperationId operationId, Function<T, byte[]> encoder, T operation, Function<byte[], R> decoder) {
        return this.execute(operationId, encoder.apply(operation)).thenApply(decoder);
    }

    public <T> void addEventListener(EventType var1, Function<byte[], T> var2, Consumer<T> var3);

    public void addEventListener(EventType var1, Runnable var2);

    public void addEventListener(EventType var1, Consumer<byte[]> var2);

    public void removeEventListener(EventType var1, Runnable var2);

    public void removeEventListener(EventType var1, Consumer var2);

    public CompletableFuture<PrimitiveProxy> connect();

    public CompletableFuture<Void> close();

    public static enum State {
        CONNECTED,
        SUSPENDED,
        CLOSED;

    }
}

