/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.impl.DefaultProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.protocols.backup.MultiPrimaryProtocolBuilder;
import io.atomix.protocols.backup.MultiPrimaryProtocolConfig;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.utils.config.ConfigurationException;
import java.util.Collection;
import java.util.stream.Collectors;

public class MultiPrimaryProtocol
implements ProxyProtocol {
    public static final Type TYPE = new Type();
    protected final MultiPrimaryProtocolConfig config;

    public static MultiPrimaryProtocol instance() {
        return new MultiPrimaryProtocol(new MultiPrimaryProtocolConfig());
    }

    public static MultiPrimaryProtocolBuilder builder() {
        return new MultiPrimaryProtocolBuilder(new MultiPrimaryProtocolConfig());
    }

    public static MultiPrimaryProtocolBuilder builder(String group) {
        return new MultiPrimaryProtocolBuilder(new MultiPrimaryProtocolConfig().setGroup(group));
    }

    protected MultiPrimaryProtocol(MultiPrimaryProtocolConfig config) {
        this.config = config;
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.config.getGroup();
    }

    public <S> ProxyClient<S> newProxy(String primitiveName, PrimitiveType primitiveType, Class<S> serviceType, ServiceConfig serviceConfig, PartitionService partitionService) {
        PartitionGroup partitionGroup = partitionService.getPartitionGroup((ProxyProtocol)this);
        if (partitionGroup == null) {
            throw new ConfigurationException("No Raft partition group matching the configured protocol exists");
        }
        Collection partitions = partitionGroup.getPartitions().stream().map(partition -> (SessionClient)((PrimaryBackupPartition)partition).getClient().sessionBuilder(primitiveName, primitiveType, serviceConfig).withConsistency(this.config.getConsistency()).withReplication(this.config.getReplication()).withRecovery(this.config.getRecovery()).withNumBackups(this.config.getBackups()).withMaxRetries(this.config.getMaxRetries()).withRetryDelay(this.config.getRetryDelay()).build()).collect(Collectors.toList());
        return new DefaultProxyClient(primitiveName, primitiveType, (PrimitiveProtocol)this, serviceType, partitions, this.config.getPartitioner());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type()).add("group", (Object)this.group()).toString();
    }

    public static final class Type
    implements PrimitiveProtocol.Type<MultiPrimaryProtocolConfig> {
        private static final String NAME = "multi-primary";

        public String name() {
            return NAME;
        }

        public MultiPrimaryProtocolConfig newConfig() {
            return new MultiPrimaryProtocolConfig();
        }

        public PrimitiveProtocol newProtocol(MultiPrimaryProtocolConfig config) {
            return new MultiPrimaryProtocol(config);
        }
    }
}

