/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.MemberGroupStrategy;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.protocols.backup.partition.PrimaryBackupPartitionGroupConfig;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadPoolContextFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionGroup
implements ManagedPartitionGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrimaryBackupPartitionGroup.class);
    private final String name;
    private final Map<PartitionId, PrimaryBackupPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private ThreadContextFactory threadFactory;

    public static Builder builder(String name) {
        return new Builder((PrimaryBackupPartitionGroupConfig)new PrimaryBackupPartitionGroupConfig().setName(name));
    }

    private static Collection<PrimaryBackupPartition> buildPartitions(PrimaryBackupPartitionGroupConfig config) {
        ArrayList<PrimaryBackupPartition> partitions = new ArrayList<PrimaryBackupPartition>(config.getPartitions());
        for (int i = 0; i < config.getPartitions(); ++i) {
            partitions.add(new PrimaryBackupPartition(PartitionId.from((String)config.getName(), (int)(i + 1)), config.getMemberGroupProvider()));
        }
        return partitions;
    }

    public PrimaryBackupPartitionGroup(PrimaryBackupPartitionGroupConfig config) {
        this(config.getName(), PrimaryBackupPartitionGroup.buildPartitions(config));
    }

    private PrimaryBackupPartitionGroup(String name, Collection<PrimaryBackupPartition> partitions) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        partitions.forEach(p -> {
            this.partitions.put(p.id(), (PrimaryBackupPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    public String name() {
        return this.name;
    }

    public PrimitiveProtocol.Type type() {
        return MultiPrimaryProtocol.TYPE;
    }

    public PrimitiveProtocol newProtocol() {
        return MultiPrimaryProtocol.builder(this.name).withRecovery(Recovery.RECOVER).withBackups(2).withReplication(Replication.SYNCHRONOUS).build();
    }

    public Partition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<ManagedPartitionGroup> open(PartitionManagementService managementService) {
        this.threadFactory = new ThreadPoolContextFactory("atomix-" + this.name() + "-%d", Runtime.getRuntime().availableProcessors() * 2, LOGGER);
        List<CompletableFuture> futures = this.partitions.values().stream().map(p -> p.open(managementService, this.threadFactory)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(PrimaryBackupPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> {
            this.threadFactory.close();
            LOGGER.info("Stopped");
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder<PrimaryBackupPartitionGroupConfig> {
        protected Builder(PrimaryBackupPartitionGroupConfig config) {
            super((PartitionGroupConfig)config);
        }

        public Builder withNumPartitions(int numPartitions) {
            ((PrimaryBackupPartitionGroupConfig)this.config).setPartitions(numPartitions);
            return this;
        }

        public Builder withMemberGroupProvider(MemberGroupProvider memberGroupProvider) {
            ((PrimaryBackupPartitionGroupConfig)this.config).setMemberGroupProvider(memberGroupProvider);
            return this;
        }

        public Builder withMemberGroupStrategy(MemberGroupStrategy memberGroupStrategy) {
            return this.withMemberGroupProvider((MemberGroupProvider)memberGroupStrategy);
        }

        public Builder withMemberGroups(MemberGroup ... memberGroups) {
            return this.withMemberGroups(Arrays.asList(memberGroups));
        }

        public Builder withMemberGroups(Collection<MemberGroup> memberGroups) {
            return this.withMemberGroupProvider(nodes -> memberGroups);
        }

        public PrimaryBackupPartitionGroup build() {
            return new PrimaryBackupPartitionGroup((PrimaryBackupPartitionGroupConfig)this.config);
        }
    }
}

