/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterService;
import io.atomix.primitive.PrimitiveClient;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.Member;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.BlockingAwarePrimitiveProxy;
import io.atomix.primitive.proxy.impl.RecoveringPrimitiveProxy;
import io.atomix.primitive.proxy.impl.RetryingPrimitiveProxy;
import io.atomix.primitive.session.SessionId;
import io.atomix.primitive.session.SessionIdService;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import io.atomix.protocols.backup.protocol.MetadataRequest;
import io.atomix.protocols.backup.protocol.PrimaryBackupClientProtocol;
import io.atomix.protocols.backup.protocol.PrimaryBackupResponse;
import io.atomix.protocols.backup.protocol.PrimitiveDescriptor;
import io.atomix.protocols.backup.proxy.PrimaryBackupProxy;
import io.atomix.protocols.backup.serializer.impl.PrimaryBackupSerializers;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Serializer;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class PrimaryBackupClient
implements PrimitiveClient<MultiPrimaryProtocol> {
    private static final Serializer SERIALIZER = PrimaryBackupSerializers.PROTOCOL;
    private final String clientName;
    private final ClusterService clusterService;
    private final PrimaryBackupClientProtocol protocol;
    private final PrimaryElection primaryElection;
    private final SessionIdService sessionIdService;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext threadContext;

    public static Builder builder() {
        return new Builder();
    }

    public PrimaryBackupClient(String clientName, ClusterService clusterService, PrimaryBackupClientProtocol protocol, PrimaryElection primaryElection, SessionIdService sessionIdService, ThreadContextFactory threadContextFactory) {
        this.clientName = clientName;
        this.clusterService = clusterService;
        this.protocol = protocol;
        this.primaryElection = primaryElection;
        this.sessionIdService = sessionIdService;
        this.threadContextFactory = threadContextFactory;
        this.threadContext = threadContextFactory.createContext();
    }

    public PrimitiveProxy newProxy(String primitiveName, PrimitiveType primitiveType) {
        return this.newProxy(primitiveName, primitiveType, MultiPrimaryProtocol.builder().withMaxRetries(5).withRetryDelay(Duration.ofMillis(100L)).withBackups(2).withReplication(Replication.ASYNCHRONOUS).build());
    }

    public PrimitiveProxy newProxy(String primitiveName, PrimitiveType primitiveType, MultiPrimaryProtocol primitiveProtocol) {
        Supplier<PrimitiveProxy> proxyBuilder = () -> new PrimaryBackupProxy(this.clientName, (SessionId)this.sessionIdService.nextSessionId().join(), primitiveType, new PrimitiveDescriptor(primitiveName, primitiveType.id(), primitiveProtocol.backups(), primitiveProtocol.replication()), this.clusterService, this.protocol, this.primaryElection, this.threadContextFactory.createContext());
        Object proxy = primitiveProtocol.recovery() == Recovery.RECOVER ? new RecoveringPrimitiveProxy(this.clientName, primitiveName, primitiveType, proxyBuilder, (Scheduler)this.threadContextFactory.createContext()) : proxyBuilder.get();
        if (primitiveProtocol.maxRetries() > 0) {
            proxy = new RetryingPrimitiveProxy(proxy, (Scheduler)this.threadContextFactory.createContext(), primitiveProtocol.maxRetries(), primitiveProtocol.retryDelay());
        }
        Executor executor = primitiveProtocol.executor() != null ? primitiveProtocol.executor() : this.threadContextFactory.createContext();
        return new BlockingAwarePrimitiveProxy(proxy, executor);
    }

    public CompletableFuture<Set<String>> getPrimitives(PrimitiveType primitiveType) {
        CompletableFuture<Set<String>> future = new CompletableFuture<Set<String>>();
        MetadataRequest request = MetadataRequest.request(primitiveType.id());
        this.threadContext.execute(() -> {
            Member primary = ((PrimaryTerm)this.primaryElection.getTerm().join()).primary();
            if (primary == null) {
                future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                return;
            }
            this.protocol.metadata(primary.nodeId(), request).whenCompleteAsync((response, error) -> {
                if (error == null) {
                    if (response.status() == PrimaryBackupResponse.Status.OK) {
                        future.complete(response.primitiveNames());
                    } else {
                        future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                    }
                } else {
                    future.completeExceptionally((Throwable)new PrimitiveException.Unavailable());
                }
            }, (Executor)this.threadContext);
        });
        return future;
    }

    public CompletableFuture<Void> close() {
        this.threadContext.close();
        this.threadContextFactory.close();
        return CompletableFuture.completedFuture(null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<PrimaryBackupClient> {
        protected String clientName = "atomix";
        protected ClusterService clusterService;
        protected PrimaryBackupClientProtocol protocol;
        protected PrimaryElection primaryElection;
        protected SessionIdService sessionIdService;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Runtime.getRuntime().availableProcessors();
        protected ThreadContextFactory threadContextFactory;

        public Builder withClientName(String clientName) {
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (Object)"clientName cannot be null");
            return this;
        }

        public Builder withClusterService(ClusterService clusterService) {
            this.clusterService = (ClusterService)Preconditions.checkNotNull((Object)clusterService, (Object)"clusterService cannot be null");
            return this;
        }

        public Builder withProtocol(PrimaryBackupClientProtocol protocol) {
            this.protocol = (PrimaryBackupClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withPrimaryElection(PrimaryElection primaryElection) {
            this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection, (Object)"primaryElection cannot be null");
            return this;
        }

        public Builder withSessionIdProvider(SessionIdService sessionIdService) {
            this.sessionIdService = (SessionIdService)Preconditions.checkNotNull((Object)sessionIdService, (Object)"sessionIdProvider cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public PrimaryBackupClient build() {
            ContextualLogger log = ContextualLoggerFactory.getLogger(PrimaryBackupClient.class, (LoggerContext)LoggerContext.builder(PrimaryBackupClient.class).addValue((Object)this.clientName).build());
            ThreadContextFactory threadContextFactory = this.threadContextFactory != null ? this.threadContextFactory : this.threadModel.factory("backup-client-" + this.clientName + "-%d", this.threadPoolSize, (Logger)log);
            return new PrimaryBackupClient(this.clientName, this.clusterService, this.protocol, this.primaryElection, this.sessionIdService, threadContextFactory);
        }
    }
}

