/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

import io.atomix.cluster.Node;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.partition.PrimaryBackupPartition;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupServerCommunicator;
import io.atomix.protocols.backup.serializer.impl.PrimaryBackupNamespaces;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryBackupPartitionServer
implements Managed<PrimaryBackupPartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PrimaryBackupPartition partition;
    private final PartitionManagementService managementService;
    private final ThreadContextFactory threadFactory;
    private PrimaryBackupServer server;
    private final AtomicBoolean started = new AtomicBoolean();

    public PrimaryBackupPartitionServer(PrimaryBackupPartition partition, PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.partition = partition;
        this.managementService = managementService;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<PrimaryBackupPartitionServer> start() {
        if (this.managementService.getClusterService().getLocalNode().type() == Node.Type.DATA) {
            PrimaryBackupPartitionServer primaryBackupPartitionServer = this;
            synchronized (primaryBackupPartitionServer) {
                this.server = this.buildServer();
            }
            return this.server.start().thenApply(v -> {
                this.log.info("Successfully started server for {}", (Object)this.partition.id());
                this.started.set(true);
                return this;
            });
        }
        this.started.set(true);
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    private PrimaryBackupServer buildServer() {
        return PrimaryBackupServer.builder().withServerName(this.partition.name()).withClusterService(this.managementService.getClusterService()).withProtocol(new PrimaryBackupServerCommunicator(this.partition.name(), Serializer.using((Namespace)PrimaryBackupNamespaces.PROTOCOL), this.managementService.getCommunicationService())).withPrimaryElection(this.managementService.getElectionService().getElectionFor(this.partition.id())).withPrimitiveTypes(this.managementService.getPrimitiveTypes()).withThreadContextFactory(this.threadFactory).build();
    }

    public CompletableFuture<Void> stop() {
        PrimaryBackupServer server = this.server;
        if (server != null) {
            return server.stop().thenRun(() -> this.started.set(false));
        }
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

