/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.roles;

import io.atomix.protocols.log.DistributedLogServer;
import io.atomix.protocols.log.impl.DistributedLogServerContext;
import io.atomix.protocols.log.protocol.BackupOperation;
import io.atomix.protocols.log.protocol.BackupRequest;
import io.atomix.protocols.log.protocol.BackupResponse;
import io.atomix.protocols.log.protocol.LogEntry;
import io.atomix.protocols.log.roles.LogServerRole;
import io.atomix.storage.StorageException;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalWriter;
import java.util.concurrent.CompletableFuture;

public class FollowerRole
extends LogServerRole {
    public FollowerRole(DistributedLogServerContext service) {
        super(DistributedLogServer.Role.FOLLOWER, service);
    }

    @Override
    public CompletableFuture<BackupResponse> backup(BackupRequest request) {
        this.logRequest(request);
        if (request.term() > this.context.currentTerm()) {
            this.context.resetTerm(request.term(), request.leader());
        } else if (request.term() < this.context.currentTerm()) {
            return CompletableFuture.completedFuture(BackupResponse.error());
        }
        JournalWriter<LogEntry> writer = this.context.writer();
        JournalReader<LogEntry> reader = this.context.reader();
        for (BackupOperation operation : request.batch()) {
            if (reader.getNextIndex() != operation.index()) {
                reader.reset(operation.index());
            }
            if (!reader.hasNext()) {
                try {
                    writer.append((Object)new LogEntry(operation.term(), operation.timestamp(), operation.value()));
                    continue;
                }
                catch (StorageException e) {
                    return CompletableFuture.completedFuture(BackupResponse.error());
                }
            }
            if (((LogEntry)reader.next().entry()).term() == operation.term()) continue;
            writer.truncate(operation.index());
            try {
                writer.append((Object)new LogEntry(operation.term(), operation.timestamp(), operation.value()));
            }
            catch (StorageException e) {
                return CompletableFuture.completedFuture(BackupResponse.error());
            }
        }
        return CompletableFuture.completedFuture(this.logResponse(BackupResponse.ok()));
    }
}

