/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.ManagedMemberGroupService;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.impl.DefaultMemberGroupService;
import io.atomix.protocols.log.impl.DistributedLogServerContext;
import io.atomix.protocols.log.protocol.LogEntry;
import io.atomix.protocols.log.protocol.LogServerProtocol;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.journal.SegmentedJournal;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class DistributedLogServer
implements Managed<DistributedLogServer> {
    final DistributedLogServerContext context;

    public static Builder builder() {
        return new Builder();
    }

    private DistributedLogServer(DistributedLogServerContext context) {
        this.context = (DistributedLogServerContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
    }

    public Role getRole() {
        return this.context.getRole();
    }

    public CompletableFuture<DistributedLogServer> start() {
        return this.context.start().thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.context.isRunning();
    }

    public CompletableFuture<Void> stop() {
        return this.context.stop();
    }

    public static class Builder
    implements io.atomix.utils.Builder<DistributedLogServer> {
        private static final String DEFAULT_SERVER_NAME = "atomix";
        private static final String DEFAULT_DIRECTORY = System.getProperty("user.dir");
        private static final int DEFAULT_REPLICATION_FACTOR = 2;
        private static final Replication DEFAULT_REPLICATION_STRATEGY = Replication.SYNCHRONOUS;
        private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
        private static final int DEFAULT_MAX_ENTRY_SIZE = 0x100000;
        private static final boolean DEFAULT_FLUSH_ON_COMMIT = false;
        private static final long DEFAULT_MAX_LOG_SIZE = 0x40000000L;
        private static final Duration DEFAULT_MAX_LOG_AGE = null;
        private static final double DEFAULT_INDEX_DENSITY = 0.005;
        protected String serverName = "atomix";
        protected ClusterMembershipService membershipService;
        protected LogServerProtocol protocol;
        protected PrimaryElection primaryElection;
        protected MemberGroupProvider memberGroupProvider;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), 4);
        protected ThreadContextFactory threadContextFactory;
        protected int replicationFactor = 2;
        protected Replication replicationStrategy = DEFAULT_REPLICATION_STRATEGY;
        protected StorageLevel storageLevel = StorageLevel.DISK;
        protected File directory = new File(DEFAULT_DIRECTORY);
        protected int maxSegmentSize = 0x2000000;
        protected int maxEntrySize = 0x100000;
        protected double indexDensity = 0.005;
        private boolean flushOnCommit = false;
        protected long maxLogSize = 0x40000000L;
        protected Duration maxLogAge = DEFAULT_MAX_LOG_AGE;

        public Builder withServerName(String serverName) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"server cannot be null");
            return this;
        }

        public Builder withMembershipService(ClusterMembershipService membershipService) {
            this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
            return this;
        }

        public Builder withProtocol(LogServerProtocol protocol) {
            this.protocol = (LogServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withPrimaryElection(PrimaryElection primaryElection) {
            this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection, (Object)"primaryElection cannot be null");
            return this;
        }

        public Builder withMemberGroupProvider(MemberGroupProvider memberGroupProvider) {
            this.memberGroupProvider = (MemberGroupProvider)Preconditions.checkNotNull((Object)memberGroupProvider);
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public Builder withReplicationFactor(int replicationFactor) {
            Preconditions.checkArgument((replicationFactor > 0 ? 1 : 0) != 0, (Object)"replicationFactor must be positive");
            this.replicationFactor = replicationFactor;
            return this;
        }

        public Builder withReplicationStrategy(Replication replicationStrategy) {
            this.replicationStrategy = (Replication)Preconditions.checkNotNull((Object)replicationStrategy, (Object)"replicationStrategy cannot be null");
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            this.storageLevel = (StorageLevel)Preconditions.checkNotNull((Object)storageLevel, (Object)"storageLevel cannot be null");
            return this;
        }

        public Builder withDirectory(String directory) {
            return this.withDirectory(new File((String)Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null")));
        }

        public Builder withDirectory(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null");
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public Builder withMaxEntrySize(int maxEntrySize) {
            Preconditions.checkArgument((maxEntrySize > 0 ? 1 : 0) != 0, (Object)"maxEntrySize must be positive");
            this.maxEntrySize = maxEntrySize;
            return this;
        }

        public Builder withIndexDensity(double indexDensity) {
            Preconditions.checkArgument((indexDensity > 0.0 && indexDensity < 1.0 ? 1 : 0) != 0, (Object)"index density must be between 0 and 1");
            this.indexDensity = indexDensity;
            return this;
        }

        public Builder withFlushOnCommit() {
            return this.withFlushOnCommit(true);
        }

        public Builder withFlushOnCommit(boolean flushOnCommit) {
            this.flushOnCommit = flushOnCommit;
            return this;
        }

        public Builder withMaxLogSize(long maxLogSize) {
            this.maxLogSize = maxLogSize;
            return this;
        }

        public Builder withMaxLogAge(Duration maxLogAge) {
            this.maxLogAge = maxLogAge;
            return this;
        }

        public DistributedLogServer build() {
            boolean closeOnStop;
            ThreadContextFactory threadContextFactory;
            ContextualLogger log = ContextualLoggerFactory.getLogger(DistributedLogServer.class, (LoggerContext)LoggerContext.builder(DistributedLogServer.class).addValue((Object)this.serverName).build());
            if (this.threadContextFactory == null) {
                threadContextFactory = this.threadModel.factory("backup-server-" + this.serverName + "-%d", this.threadPoolSize, (Logger)log);
                closeOnStop = true;
            } else {
                threadContextFactory = this.threadContextFactory;
                closeOnStop = false;
            }
            SegmentedJournal journal = SegmentedJournal.builder().withName(this.serverName).withDirectory(this.directory).withStorageLevel(this.storageLevel).withNamespace(Namespace.builder().register(Namespaces.BASIC).register(new Class[]{LogEntry.class}).register(new Class[]{byte[].class}).build()).withMaxSegmentSize(this.maxSegmentSize).withMaxEntrySize(this.maxEntrySize).withIndexDensity(this.indexDensity).withFlushOnCommit(this.flushOnCommit).build();
            return new DistributedLogServer(new DistributedLogServerContext(this.serverName, this.membershipService, (ManagedMemberGroupService)new DefaultMemberGroupService(this.membershipService, this.memberGroupProvider), this.protocol, this.primaryElection, this.replicationFactor, this.replicationStrategy, (SegmentedJournal<LogEntry>)journal, this.maxLogSize, this.maxLogAge, threadContextFactory, closeOnStop));
        }
    }

    public static enum Role {
        LEADER,
        FOLLOWER,
        NONE;

    }
}

