/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.MemberGroupStrategy;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.log.DistributedLogProtocol;
import io.atomix.protocols.log.partition.LogCompactionConfig;
import io.atomix.protocols.log.partition.LogPartition;
import io.atomix.protocols.log.partition.LogPartitionGroupConfig;
import io.atomix.protocols.log.partition.LogStorageConfig;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.concurrent.BlockingAwareThreadPoolContextFactory;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.memory.MemorySize;
import io.atomix.utils.serializer.Namespace;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPartitionGroup
implements ManagedPartitionGroup {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(LogPartitionGroup.class);
    private final String name;
    private final LogPartitionGroupConfig config;
    private final Map<PartitionId, LogPartition> partitions = Maps.newConcurrentMap();
    private final List<LogPartition> sortedPartitions = Lists.newCopyOnWriteArrayList();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private ThreadContextFactory threadFactory;

    public static Builder builder(String name) {
        return new Builder((LogPartitionGroupConfig)new LogPartitionGroupConfig().setName(name));
    }

    private static Collection<LogPartition> buildPartitions(LogPartitionGroupConfig config) {
        ArrayList<LogPartition> partitions = new ArrayList<LogPartition>(config.getPartitions());
        for (int i = 0; i < config.getPartitions(); ++i) {
            partitions.add(new LogPartition(PartitionId.from((String)config.getName(), (int)(i + 1)), config));
        }
        return partitions;
    }

    public LogPartitionGroup(LogPartitionGroupConfig config) {
        this.config = config;
        this.name = (String)Preconditions.checkNotNull((Object)config.getName());
        LogPartitionGroup.buildPartitions(config).forEach(p -> {
            this.partitions.put(p.id(), (LogPartition)p);
            this.sortedPartitions.add((LogPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
    }

    public String name() {
        return this.name;
    }

    public PartitionGroup.Type type() {
        return TYPE;
    }

    public PrimitiveProtocol.Type protocol() {
        return DistributedLogProtocol.TYPE;
    }

    public PartitionGroupConfig config() {
        return this.config;
    }

    public ProxyProtocol newProtocol() {
        return DistributedLogProtocol.builder(this.name).withRecovery(Recovery.RECOVER).build();
    }

    public LogPartition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.sortedPartitions;
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<ManagedPartitionGroup> join(PartitionManagementService managementService) {
        int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 32), 4);
        this.threadFactory = new BlockingAwareThreadPoolContextFactory("atomix-" + this.name() + "-%d", threadPoolSize, LOGGER);
        List<CompletableFuture> futures = this.partitions.values().stream().map(p -> p.join(managementService, this.threadFactory)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<ManagedPartitionGroup> connect(PartitionManagementService managementService) {
        int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 32), 4);
        this.threadFactory = new BlockingAwareThreadPoolContextFactory("atomix-" + this.name() + "-%d", threadPoolSize, LOGGER);
        List<CompletableFuture> futures = this.partitions.values().stream().map(p -> p.connect(managementService, this.threadFactory)).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(LogPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenCompleteAsync((r, e) -> {
            ThreadContextFactory threadFactory = this.threadFactory;
            if (threadFactory != null) {
                threadFactory.close();
            }
            LOGGER.info("Stopped");
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder<LogPartitionGroupConfig> {
        protected Builder(LogPartitionGroupConfig config) {
            super((PartitionGroupConfig)config);
        }

        public Builder withNumPartitions(int numPartitions) {
            ((LogPartitionGroupConfig)this.config).setPartitions(numPartitions);
            return this;
        }

        public Builder withMemberGroupStrategy(MemberGroupStrategy memberGroupStrategy) {
            ((LogPartitionGroupConfig)this.config).setMemberGroupStrategy(memberGroupStrategy);
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            ((LogPartitionGroupConfig)this.config).getStorageConfig().setLevel(storageLevel);
            return this;
        }

        public Builder withDataDirectory(File dataDir) {
            ((LogPartitionGroupConfig)this.config).getStorageConfig().setDirectory(new File("user.dir").toURI().relativize(dataDir.toURI()).getPath());
            return this;
        }

        public Builder withSegmentSize(MemorySize segmentSize) {
            ((LogPartitionGroupConfig)this.config).getStorageConfig().setSegmentSize(segmentSize);
            return this;
        }

        public Builder withSegmentSize(long segmentSizeBytes) {
            return this.withSegmentSize(new MemorySize(segmentSizeBytes));
        }

        public Builder withMaxEntrySize(MemorySize maxEntrySize) {
            ((LogPartitionGroupConfig)this.config).getStorageConfig().setMaxEntrySize(maxEntrySize);
            return this;
        }

        public Builder withMaxEntrySize(int maxEntrySize) {
            return this.withMaxEntrySize(new MemorySize((long)maxEntrySize));
        }

        public Builder withFlushOnCommit() {
            return this.withFlushOnCommit(true);
        }

        public Builder withFlushOnCommit(boolean flushOnCommit) {
            ((LogPartitionGroupConfig)this.config).getStorageConfig().setFlushOnCommit(flushOnCommit);
            return this;
        }

        public Builder withMaxSize(long maxSize) {
            ((LogPartitionGroupConfig)this.config).getCompactionConfig().setSize(MemorySize.from((long)maxSize));
            return this;
        }

        public Builder withMaxAge(Duration maxAge) {
            ((LogPartitionGroupConfig)this.config).getCompactionConfig().setAge(maxAge);
            return this;
        }

        public LogPartitionGroup build() {
            return new LogPartitionGroup((LogPartitionGroupConfig)this.config);
        }
    }

    public static class Type
    implements PartitionGroup.Type<LogPartitionGroupConfig> {
        private static final String NAME = "log";

        public String name() {
            return NAME;
        }

        public Namespace namespace() {
            return Namespace.builder().nextId(800).register(new Class[]{LogPartitionGroupConfig.class}).register(new Class[]{LogStorageConfig.class}).register(new Class[]{LogCompactionConfig.class}).register(new Class[]{MemorySize.class}).register(new Class[]{StorageLevel.class}).build();
        }

        public LogPartitionGroupConfig newConfig() {
            return new LogPartitionGroupConfig();
        }

        public ManagedPartitionGroup newPartitionGroup(LogPartitionGroupConfig config) {
            return new LogPartitionGroup(config);
        }
    }
}

