/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.partition;

import com.google.common.base.MoreObjects;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.protocols.log.partition.LogPartitionGroupConfig;
import io.atomix.protocols.log.partition.impl.LogPartitionClient;
import io.atomix.protocols.log.partition.impl.LogPartitionServer;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContextFactory;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class LogPartition
implements Partition {
    private final PartitionId partitionId;
    private final LogPartitionGroupConfig config;
    private PrimaryElection election;
    private LogPartitionServer server;
    private LogPartitionClient client;

    public LogPartition(PartitionId partitionId, LogPartitionGroupConfig config) {
        this.partitionId = partitionId;
        this.config = config;
    }

    public PartitionId id() {
        return this.partitionId;
    }

    public long term() {
        return ((PrimaryTerm)Futures.get((Future)this.election.getTerm())).term();
    }

    public Collection<MemberId> members() {
        return ((PrimaryTerm)Futures.get((Future)this.election.getTerm())).candidates().stream().map(GroupMember::memberId).collect(Collectors.toList());
    }

    public MemberId primary() {
        return ((PrimaryTerm)Futures.get((Future)this.election.getTerm())).primary().memberId();
    }

    public Collection<MemberId> backups() {
        return ((PrimaryTerm)Futures.get((Future)this.election.getTerm())).candidates().stream().map(GroupMember::memberId).collect(Collectors.toList());
    }

    public String name() {
        return String.format("%s-partition-%d", this.partitionId.group(), this.partitionId.id());
    }

    public LogPartitionClient getClient() {
        return this.client;
    }

    CompletableFuture<Partition> join(PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.election = managementService.getElectionService().getElectionFor(this.partitionId);
        this.server = new LogPartitionServer(this, managementService, this.config, threadFactory);
        this.client = new LogPartitionClient(this, managementService, threadFactory);
        return ((CompletableFuture)this.server.start().thenCompose(v -> this.client.start())).thenApply(v -> this);
    }

    CompletableFuture<Partition> connect(PartitionManagementService managementService, ThreadContextFactory threadFactory) {
        this.election = managementService.getElectionService().getElectionFor(this.partitionId);
        this.client = new LogPartitionClient(this, managementService, threadFactory);
        return this.client.start().thenApply(v -> this);
    }

    public CompletableFuture<Void> close() {
        if (this.client == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.client.stop().whenComplete((clientResult, clientError) -> {
            if (this.server != null) {
                this.server.stop().whenComplete((serverResult, serverError) -> future.complete(null));
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.partitionId).toString();
    }
}

