/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.gossip.AntiEntropyProtocol;
import io.atomix.protocols.gossip.PeerSelector;
import io.atomix.protocols.gossip.PeerSelectors;
import io.atomix.protocols.gossip.TimestampProvider;
import io.atomix.protocols.gossip.TimestampProviders;
import java.time.Duration;
import java.util.Set;

@Beta
public class AntiEntropyProtocolConfig
extends PrimitiveProtocolConfig<AntiEntropyProtocolConfig> {
    private TimestampProvider timestampProvider = TimestampProviders.WALL_CLOCK;
    private Set<String> peers;
    private PeerSelector peerSelector = PeerSelectors.RANDOM;
    private boolean tombstonesDisabled;
    private Duration gossipInterval = Duration.ofMillis(50L);
    private Duration antiEntropyInterval = Duration.ofMillis(500L);

    public PrimitiveProtocol.Type getType() {
        return AntiEntropyProtocol.TYPE;
    }

    public TimestampProvider getTimestampProvider() {
        return this.timestampProvider;
    }

    public AntiEntropyProtocolConfig setTimestampProvider(TimestampProvider timestampProvider) {
        this.timestampProvider = (TimestampProvider)Preconditions.checkNotNull((Object)timestampProvider);
        return this;
    }

    public AntiEntropyProtocolConfig setTimestampProvider(TimestampProviders timestampProvider) {
        return this.setTimestampProvider((TimestampProvider)timestampProvider);
    }

    public Set<String> getPeers() {
        return this.peers;
    }

    public AntiEntropyProtocolConfig setPeers(Set<String> peers) {
        this.peers = peers;
        return this;
    }

    public PeerSelector getPeerSelector() {
        return this.peerSelector;
    }

    public AntiEntropyProtocolConfig setPeerSelector(PeerSelector peerSelector) {
        this.peerSelector = (PeerSelector)Preconditions.checkNotNull((Object)peerSelector);
        return this;
    }

    public AntiEntropyProtocolConfig setPeerSelector(PeerSelectors peerSelector) {
        return this.setPeerSelector((PeerSelector)peerSelector);
    }

    public boolean isTombstonesDisabled() {
        return this.tombstonesDisabled;
    }

    public AntiEntropyProtocolConfig setTombstonesDisabled(boolean tombstonesDisabled) {
        this.tombstonesDisabled = tombstonesDisabled;
        return this;
    }

    public Duration getGossipInterval() {
        return this.gossipInterval;
    }

    public AntiEntropyProtocolConfig setGossipInterval(Duration gossipInterval) {
        this.gossipInterval = (Duration)Preconditions.checkNotNull((Object)gossipInterval);
        return this;
    }

    public Duration getAntiEntropyInterval() {
        return this.antiEntropyInterval;
    }

    public AntiEntropyProtocolConfig setAntiEntropyInterval(Duration antiEntropyInterval) {
        this.antiEntropyInterval = (Duration)Preconditions.checkNotNull((Object)antiEntropyInterval);
        return this;
    }
}

