/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.set.SetDelegate;
import io.atomix.primitive.protocol.set.SetDelegateEvent;
import io.atomix.primitive.protocol.set.SetDelegateEventListener;
import io.atomix.protocols.gossip.CrdtProtocolConfig;
import io.atomix.protocols.gossip.TimestampProvider;
import io.atomix.protocols.gossip.set.SetElement;
import io.atomix.utils.event.Event;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class CrdtSetDelegate<E>
implements SetDelegate<E> {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).register(new Class[]{SetElement.class}).build());
    private final ClusterCommunicationService clusterCommunicator;
    private final ScheduledExecutorService executorService;
    private final Serializer elementSerializer;
    private final TimestampProvider<E> timestampProvider;
    private final String subject;
    private volatile ScheduledFuture<?> broadcastFuture;
    protected final Map<String, SetElement> elements = Maps.newConcurrentMap();
    private final Set<SetDelegateEventListener<E>> eventListeners = Sets.newCopyOnWriteArraySet();

    public CrdtSetDelegate(String name, Serializer serializer, CrdtProtocolConfig config, PrimitiveManagementService managementService) {
        this.clusterCommunicator = managementService.getCommunicationService();
        this.executorService = managementService.getExecutorService();
        this.elementSerializer = serializer;
        this.timestampProvider = config.getTimestampProvider();
        this.subject = String.format("atomix-crdt-set-%s", name);
        this.clusterCommunicator.subscribe(this.subject, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::updateElements, (Executor)this.executorService);
        this.broadcastFuture = this.executorService.scheduleAtFixedRate(this::broadcastElements, config.getGossipInterval().toMillis(), config.getGossipInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public int size() {
        return this.set().size();
    }

    public boolean isEmpty() {
        return this.set().isEmpty();
    }

    public boolean contains(Object o) {
        return this.set().contains(o);
    }

    public Iterator<E> iterator() {
        return this.set().iterator();
    }

    public Object[] toArray() {
        return this.set().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.set().toArray(a);
    }

    public boolean add(E e) {
        SetElement element = new SetElement(this.encode(e), this.timestampProvider.get(e), false);
        if (this.add(element)) {
            this.eventListeners.forEach(listener -> listener.event((Event)new SetDelegateEvent(SetDelegateEvent.Type.ADD, e)));
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        SetElement element = new SetElement(this.encode(o), this.timestampProvider.get(o), true);
        if (this.remove(element)) {
            this.eventListeners.forEach(listener -> listener.event((Event)new SetDelegateEvent(SetDelegateEvent.Type.REMOVE, o)));
            return true;
        }
        return false;
    }

    private boolean add(SetElement element) {
        AtomicBoolean added = new AtomicBoolean();
        this.elements.compute(element.value(), (k, v) -> {
            if (v == null) {
                added.set(true);
                return element;
            }
            if (v.isNewerThan(element) || !v.isTombstone()) {
                return v;
            }
            added.set(true);
            return element;
        });
        return added.get();
    }

    private boolean remove(SetElement element) {
        AtomicBoolean removed = new AtomicBoolean();
        this.elements.compute(element.value(), (k, v) -> {
            if (v == null) {
                return null;
            }
            if (element.isOlderThan((SetElement)v) || v.isTombstone()) {
                return v;
            }
            removed.set(true);
            return element;
        });
        return removed.get();
    }

    public boolean containsAll(Collection<?> c) {
        return this.set().containsAll(c);
    }

    public boolean addAll(Collection<? extends E> c) {
        return c.stream().map(e -> this.add(e)).reduce(Boolean::logicalOr).orElse(false);
    }

    public boolean retainAll(Collection<?> c) {
        return this.set().stream().filter(e -> !c.contains(e)).map(e -> this.remove(e)).reduce(Boolean::logicalOr).orElse(false);
    }

    public boolean removeAll(Collection<?> c) {
        return c.stream().map(e -> this.remove(e)).reduce(Boolean::logicalOr).orElse(false);
    }

    public void clear() {
        this.removeAll(this.set());
    }

    public void addListener(SetDelegateEventListener<E> listener) {
        this.eventListeners.add(listener);
    }

    public void removeListener(SetDelegateEventListener<E> listener) {
        this.eventListeners.remove(listener);
    }

    protected Set<E> set() {
        return this.elements.entrySet().stream().filter(entry -> !((SetElement)entry.getValue()).isTombstone()).map(entry -> this.decode((String)entry.getKey())).collect(Collectors.toSet());
    }

    private String encode(Object element) {
        return BaseEncoding.base16().encode(this.elementSerializer.encode(element));
    }

    protected E decode(String element) {
        return (E)this.elementSerializer.decode(BaseEncoding.base16().decode((CharSequence)element));
    }

    private void updateElements(Map<String, SetElement> elements) {
        for (SetElement element : elements.values()) {
            if (element.isTombstone()) {
                if (!this.remove(element)) continue;
                this.eventListeners.forEach(listener -> listener.event((Event)new SetDelegateEvent(SetDelegateEvent.Type.REMOVE, this.decode(element.value()))));
                continue;
            }
            if (!this.add(element)) continue;
            this.eventListeners.forEach(listener -> listener.event((Event)new SetDelegateEvent(SetDelegateEvent.Type.ADD, this.decode(element.value()))));
        }
    }

    private void broadcastElements() {
        this.clusterCommunicator.broadcast(this.subject, this.elements, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    public void close() {
        this.broadcastFuture.cancel(false);
        this.clusterCommunicator.unsubscribe(this.subject);
    }
}

