/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.value;

import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.Subscription;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.value.ValueDelegate;
import io.atomix.primitive.protocol.value.ValueDelegateEvent;
import io.atomix.primitive.protocol.value.ValueDelegateEventListener;
import io.atomix.protocols.gossip.CrdtProtocolConfig;
import io.atomix.protocols.gossip.TimestampProvider;
import io.atomix.protocols.gossip.value.Value;
import io.atomix.utils.event.Event;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CrdtValueDelegate<V>
implements ValueDelegate<V> {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(Namespaces.BASIC).register(new Class[]{Value.class}).build());
    private final ClusterEventService clusterEventService;
    private final ScheduledExecutorService executorService;
    private final Serializer valueSerializer;
    private final TimestampProvider<V> timestampProvider;
    private final String subject;
    private volatile CompletableFuture<Subscription> subscribeFuture;
    private volatile ScheduledFuture<?> broadcastFuture;
    private final AtomicReference<Value> currentValue = new AtomicReference();
    private final Set<ValueDelegateEventListener<V>> eventListeners = Sets.newCopyOnWriteArraySet();

    public CrdtValueDelegate(String name, Serializer serializer, CrdtProtocolConfig config, PrimitiveManagementService managementService) {
        this.clusterEventService = managementService.getEventService();
        this.executorService = managementService.getExecutorService();
        this.valueSerializer = serializer;
        this.timestampProvider = config.getTimestampProvider();
        this.subject = String.format("atomix-crdt-value-%s", name);
        this.subscribeFuture = this.clusterEventService.subscribe(this.subject, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), this::updateValue, (Executor)this.executorService);
        this.broadcastFuture = this.executorService.scheduleAtFixedRate(this::broadcastValue, config.getGossipInterval().toMillis(), config.getGossipInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public V get() {
        Value value = this.currentValue.get();
        return value != null ? (V)this.decode(value.value()) : null;
    }

    public V getAndSet(V value) {
        Value oldValue;
        Value newValue = new Value(this.encode(value), this.timestampProvider.get(value));
        while (newValue.isNewerThan(oldValue = this.currentValue.get())) {
            if (!this.currentValue.compareAndSet(oldValue, newValue)) continue;
            if (oldValue == null || !Objects.equals(oldValue.value(), newValue.value())) {
                this.eventListeners.forEach(listener -> listener.event((Event)new ValueDelegateEvent(ValueDelegateEvent.Type.UPDATE, value)));
            }
            return oldValue != null ? (V)this.decode(oldValue.value()) : null;
        }
        return value;
    }

    public void set(V value) {
        Value oldValue;
        Value newValue = new Value(this.encode(value), this.timestampProvider.get(value));
        while (newValue.isNewerThan(oldValue = this.currentValue.get())) {
            if (!this.currentValue.compareAndSet(oldValue, newValue)) continue;
            if (oldValue != null && Objects.equals(oldValue.value(), newValue.value())) break;
            this.eventListeners.forEach(listener -> listener.event((Event)new ValueDelegateEvent(ValueDelegateEvent.Type.UPDATE, value)));
            break;
        }
    }

    public void addListener(ValueDelegateEventListener<V> listener) {
        this.eventListeners.add(listener);
    }

    public void removeListener(ValueDelegateEventListener<V> listener) {
        this.eventListeners.remove(listener);
    }

    private String encode(Object value) {
        return BaseEncoding.base16().encode(this.valueSerializer.encode(value));
    }

    protected V decode(String value) {
        return (V)this.valueSerializer.decode(BaseEncoding.base16().decode((CharSequence)value));
    }

    private void updateValue(Value value) {
        Value current;
        while (value.isNewerThan(current = this.currentValue.get())) {
            if (!this.currentValue.compareAndSet(current, value)) continue;
            if (current != null && Objects.equals(current.value(), value.value())) break;
            this.eventListeners.forEach(listener -> listener.event((Event)new ValueDelegateEvent(ValueDelegateEvent.Type.UPDATE, this.decode(value.value()))));
            break;
        }
    }

    private void broadcastValue() {
        this.clusterEventService.broadcast(this.subject, (Object)this.currentValue.get(), arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
    }

    public void close() {
        this.broadcastFuture.cancel(false);
        this.subscribeFuture.thenAccept(subscription -> subscription.close());
    }
}

