/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.internal.MapCommands;
import io.atomix.collections.util.DistributedMapFactory;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-11, factory=DistributedMapFactory.class)
public class DistributedMap<K, V>
extends AbstractResource<DistributedMap<K, V>> {
    public DistributedMap(CopycatClient client) {
        this(client, (Properties)new Resource.Options());
    }

    public DistributedMap(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit((Query)new MapCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.IsEmpty(consistency.level()));
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit((Query)new MapCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.Size(consistency.level()));
    }

    public CompletableFuture<Boolean> containsKey(Object key) {
        return this.client.submit((Query)new MapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsKey(Object key, ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.ContainsKey(key, consistency.level()));
    }

    public CompletableFuture<Boolean> containsValue(Object value) {
        return this.client.submit((Query)new MapCommands.ContainsValue(value));
    }

    public CompletableFuture<Boolean> containsValue(Object value, ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.ContainsValue(value, consistency.level()));
    }

    public CompletableFuture<V> get(Object key) {
        return this.client.submit((Query)new MapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<V> get(Object key, ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.Get(key, consistency.level())).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue) {
        return this.client.submit((Query)new MapCommands.GetOrDefault(key, defaultValue)).thenApply(result -> result);
    }

    public CompletableFuture<V> getOrDefault(Object key, V defaultValue, ReadConsistency consistency) {
        return this.client.submit((Query)new MapCommands.GetOrDefault(key, defaultValue, consistency.level())).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value) {
        return this.client.submit((Command)new MapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> put(K key, V value, Duration ttl) {
        return this.client.submit((Command)new MapCommands.Put(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.client.submit((Command)new MapCommands.PutIfAbsent(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value, Duration ttl) {
        return this.client.submit((Command)new MapCommands.PutIfAbsent(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<V> remove(Object key) {
        return this.client.submit((Command)new MapCommands.Remove(key)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.client.submit((Command)new MapCommands.RemoveIfPresent(key, value));
    }

    public CompletableFuture<V> replace(K key, V value) {
        return this.client.submit((Command)new MapCommands.Replace(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<V> replace(K key, V value, Duration ttl) {
        return this.client.submit((Command)new MapCommands.Replace(key, value, ttl.toMillis())).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.client.submit((Command)new MapCommands.ReplaceIfPresent(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue, Duration ttl) {
        return this.client.submit((Command)new MapCommands.ReplaceIfPresent(key, oldValue, newValue, ttl.toMillis()));
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.client.submit((Query)new MapCommands.KeySet()).thenApply(keys -> keys);
    }

    public CompletableFuture<Collection<V>> values() {
        return this.client.submit((Query)new MapCommands.Values()).thenApply(values -> values);
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.client.submit((Query)new MapCommands.EntrySet()).thenApply(entries -> entries);
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit((Command)new MapCommands.Clear());
    }
}

