/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.messaging.impl.ProtocolMessage;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageDecoderV1
extends ByteToMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Escape ESCAPE = new Escape();
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private static final int BYTE_SIZE = 1;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private DecoderState currentState = DecoderState.READ_SENDER_IP;
    private InetAddress senderIp;
    private int senderPort;
    private Address senderAddress;
    private ProtocolMessage.Type type;
    private long messageId;
    private int contentLength;
    private byte[] content;
    private int subjectLength;

    MessageDecoderV1() {
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) throws Exception {
        block2 : switch (this.currentState) {
            case READ_SENDER_IP: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                buffer.markReaderIndex();
                byte octetsLength = buffer.readByte();
                if (buffer.readableBytes() < octetsLength) {
                    buffer.resetReaderIndex();
                    return;
                }
                byte[] octets = new byte[octetsLength];
                buffer.readBytes(octets);
                this.senderIp = InetAddress.getByAddress(octets);
                this.currentState = DecoderState.READ_SENDER_PORT;
            }
            case READ_SENDER_PORT: {
                if (buffer.readableBytes() < 4) {
                    return;
                }
                this.senderPort = buffer.readInt();
                this.senderAddress = new Address(this.senderIp.getHostName(), this.senderPort, this.senderIp);
                this.currentState = DecoderState.READ_TYPE;
            }
            case READ_TYPE: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                this.type = ProtocolMessage.Type.forId(buffer.readByte());
                this.currentState = DecoderState.READ_MESSAGE_ID;
            }
            case READ_MESSAGE_ID: {
                try {
                    this.messageId = MessageDecoderV1.readLong(buffer);
                }
                catch (Escape e) {
                    return;
                }
                this.currentState = DecoderState.READ_CONTENT_LENGTH;
            }
            case READ_CONTENT_LENGTH: {
                try {
                    this.contentLength = MessageDecoderV1.readInt(buffer);
                }
                catch (Escape e) {
                    return;
                }
                this.currentState = DecoderState.READ_CONTENT;
            }
            case READ_CONTENT: {
                if (buffer.readableBytes() < this.contentLength) {
                    return;
                }
                if (this.contentLength > 0) {
                    this.content = new byte[this.contentLength];
                    buffer.readBytes(this.content);
                } else {
                    this.content = EMPTY_PAYLOAD;
                }
                switch (this.type) {
                    case REQUEST: {
                        this.currentState = DecoderState.READ_SUBJECT_LENGTH;
                        break block2;
                    }
                    case REPLY: {
                        this.currentState = DecoderState.READ_STATUS;
                        break block2;
                    }
                }
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
                break;
            }
        }
        block14 : switch (this.type) {
            case REQUEST: {
                ProtocolMessage message;
                switch (this.currentState) {
                    case READ_SUBJECT_LENGTH: {
                        if (buffer.readableBytes() < 2) {
                            return;
                        }
                        this.subjectLength = buffer.readShort();
                        this.currentState = DecoderState.READ_SUBJECT;
                    }
                    case READ_SUBJECT: {
                        if (buffer.readableBytes() < this.subjectLength) {
                            return;
                        }
                        String subject = MessageDecoderV1.readString(buffer, this.subjectLength, StandardCharsets.UTF_8);
                        message = new ProtocolRequest(this.messageId, this.senderAddress, subject, this.content);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block14;
                    }
                }
                break;
            }
            case REPLY: {
                ProtocolMessage message;
                switch (this.currentState) {
                    case READ_STATUS: {
                        if (buffer.readableBytes() < 1) {
                            return;
                        }
                        ProtocolReply.Status status = ProtocolReply.Status.forId(buffer.readByte());
                        message = new ProtocolReply(this.messageId, this.content, status);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block14;
                    }
                }
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
            }
        }
    }

    static int readInt(ByteBuf buffer) {
        if (buffer.readableBytes() < 5) {
            return MessageDecoderV1.readIntSlow(buffer);
        }
        return MessageDecoderV1.readIntFast(buffer);
    }

    static int readIntFast(ByteBuf buffer) {
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return result;
    }

    static int readIntSlow(ByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            throw ESCAPE;
        }
        buffer.markReaderIndex();
        byte b = buffer.readByte();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (buffer.readableBytes() == 0) {
                buffer.resetReaderIndex();
                throw ESCAPE;
            }
            b = buffer.readByte();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                if (buffer.readableBytes() == 0) {
                    buffer.resetReaderIndex();
                    throw ESCAPE;
                }
                b = buffer.readByte();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    if (buffer.readableBytes() == 0) {
                        buffer.resetReaderIndex();
                        throw ESCAPE;
                    }
                    b = buffer.readByte();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        if (buffer.readableBytes() == 0) {
                            buffer.resetReaderIndex();
                            throw ESCAPE;
                        }
                        b = buffer.readByte();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return result;
    }

    static long readLong(ByteBuf buffer) {
        if (buffer.readableBytes() < 9) {
            return MessageDecoderV1.readLongSlow(buffer);
        }
        return MessageDecoderV1.readLongFast(buffer);
    }

    static long readLongFast(ByteBuf buffer) {
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    static long readLongSlow(ByteBuf buffer) {
        if (buffer.readableBytes() == 0) {
            throw ESCAPE;
        }
        buffer.markReaderIndex();
        byte b = buffer.readByte();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            if (buffer.readableBytes() == 0) {
                buffer.resetReaderIndex();
                throw ESCAPE;
            }
            b = buffer.readByte();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                if (buffer.readableBytes() == 0) {
                    buffer.resetReaderIndex();
                    throw ESCAPE;
                }
                b = buffer.readByte();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    if (buffer.readableBytes() == 0) {
                        buffer.resetReaderIndex();
                        throw ESCAPE;
                    }
                    b = buffer.readByte();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        if (buffer.readableBytes() == 0) {
                            buffer.resetReaderIndex();
                            throw ESCAPE;
                        }
                        b = buffer.readByte();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            if (buffer.readableBytes() == 0) {
                                buffer.resetReaderIndex();
                                throw ESCAPE;
                            }
                            b = buffer.readByte();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                if (buffer.readableBytes() == 0) {
                                    buffer.resetReaderIndex();
                                    throw ESCAPE;
                                }
                                b = buffer.readByte();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    if (buffer.readableBytes() == 0) {
                                        buffer.resetReaderIndex();
                                        throw ESCAPE;
                                    }
                                    b = buffer.readByte();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        if (buffer.readableBytes() == 0) {
                                            buffer.resetReaderIndex();
                                            throw ESCAPE;
                                        }
                                        b = buffer.readByte();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    static String readString(ByteBuf buffer, int length, Charset charset) {
        if (buffer.isDirect()) {
            String result = buffer.toString(buffer.readerIndex(), length, charset);
            buffer.skipBytes(length);
            return result;
        }
        if (buffer.hasArray()) {
            String result = new String(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), length, charset);
            buffer.skipBytes(length);
            return result;
        }
        byte[] array = new byte[length];
        buffer.readBytes(array);
        return new String(array, charset);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        try {
            this.log.error("Exception inside channel handling pipeline.", cause);
        }
        finally {
            context.close();
        }
    }

    static enum DecoderState {
        READ_TYPE,
        READ_MESSAGE_ID,
        READ_SENDER_IP,
        READ_SENDER_PORT,
        READ_SUBJECT_LENGTH,
        READ_SUBJECT,
        READ_STATUS,
        READ_CONTENT_LENGTH,
        READ_CONTENT;

    }

    private static class Escape
    extends RuntimeException {
        private Escape() {
        }
    }
}

