/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Node;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.discovery.BootstrapDiscoveryBuilder;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.utils.event.AbstractListenerManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapDiscoveryProvider
extends AbstractListenerManager<NodeDiscoveryEvent, NodeDiscoveryEventListener>
implements NodeDiscoveryProvider {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapDiscoveryProvider.class);
    private final ImmutableSet<Node> bootstrapNodes;
    private final BootstrapDiscoveryConfig config;

    public static BootstrapDiscoveryBuilder builder() {
        return new BootstrapDiscoveryBuilder();
    }

    public BootstrapDiscoveryProvider(Node ... bootstrapNodes) {
        this(Arrays.asList(bootstrapNodes));
    }

    public BootstrapDiscoveryProvider(Collection<Node> bootstrapNodes) {
        this(new BootstrapDiscoveryConfig().setNodes(bootstrapNodes.stream().map(node -> new NodeConfig().setId(node.id()).setAddress(node.address())).collect(Collectors.toList())));
    }

    BootstrapDiscoveryProvider(BootstrapDiscoveryConfig config) {
        this.config = (BootstrapDiscoveryConfig)Preconditions.checkNotNull((Object)config);
        this.bootstrapNodes = ImmutableSet.copyOf((Collection)config.getNodes().stream().map(Node::new).collect(Collectors.toList()));
    }

    public BootstrapDiscoveryConfig config() {
        return this.config;
    }

    @Override
    public Set<Node> getNodes() {
        return this.bootstrapNodes;
    }

    @Override
    public CompletableFuture<Void> join(BootstrapService bootstrap, Node localNode) {
        LOGGER.info("Joined");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> leave(Node localNode) {
        LOGGER.info("Left");
        return CompletableFuture.completedFuture(null);
    }

    public static class Type
    implements NodeDiscoveryProvider.Type<BootstrapDiscoveryConfig> {
        private static final String NAME = "bootstrap";

        public String name() {
            return NAME;
        }

        public BootstrapDiscoveryConfig newConfig() {
            return new BootstrapDiscoveryConfig();
        }

        @Override
        public NodeDiscoveryProvider newProvider(BootstrapDiscoveryConfig config) {
            return new BootstrapDiscoveryProvider(config);
        }
    }
}

