/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.cluster.protocol.HeartbeatMembershipProtocolConfig;
import io.atomix.utils.Builder;
import io.atomix.utils.net.Address;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;

public class AtomixClusterBuilder
implements Builder<AtomixCluster> {
    protected final ClusterConfig config;

    protected AtomixClusterBuilder() {
        this(new ClusterConfig());
    }

    protected AtomixClusterBuilder(ClusterConfig config) {
        this.config = (ClusterConfig)Preconditions.checkNotNull((Object)config);
    }

    public AtomixClusterBuilder withClusterId(String clusterId) {
        this.config.setClusterId(clusterId);
        return this;
    }

    public AtomixClusterBuilder withMemberId(String localMemberId) {
        this.config.getNodeConfig().setId(localMemberId);
        return this;
    }

    public AtomixClusterBuilder withMemberId(MemberId localMemberId) {
        this.config.getNodeConfig().setId(localMemberId);
        return this;
    }

    public AtomixClusterBuilder withHost(String host) {
        this.config.getNodeConfig().setHost(host);
        return this;
    }

    public AtomixClusterBuilder withPort(int port) {
        this.config.getNodeConfig().setPort(port);
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder withAddress(String address) {
        return this.withAddress(Address.from((String)address));
    }

    @Deprecated
    public AtomixClusterBuilder withAddress(String host, int port) {
        return this.withAddress(Address.from((String)host, (int)port));
    }

    @Deprecated
    public AtomixClusterBuilder withAddress(int port) {
        return this.withAddress(Address.from((int)port));
    }

    public AtomixClusterBuilder withAddress(Address address) {
        this.config.getNodeConfig().setAddress(address);
        return this;
    }

    public AtomixClusterBuilder withZoneId(String zoneId) {
        this.config.getNodeConfig().setZoneId(zoneId);
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder withZone(String zone) {
        this.config.getNodeConfig().setZoneId(zone);
        return this;
    }

    public AtomixClusterBuilder withRackId(String rackId) {
        this.config.getNodeConfig().setRackId(rackId);
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder withRack(String rack) {
        this.config.getNodeConfig().setRackId(rack);
        return this;
    }

    public AtomixClusterBuilder withHostId(String hostId) {
        this.config.getNodeConfig().setHostId(hostId);
        return this;
    }

    public AtomixClusterBuilder withProperties(Properties properties) {
        this.config.getNodeConfig().setProperties(properties);
        return this;
    }

    public AtomixClusterBuilder withProperty(String key, String value) {
        this.config.getNodeConfig().setProperty(key, value);
        return this;
    }

    public AtomixClusterBuilder withMessagingInterface(String iface) {
        return this.withMessagingInterfaces(Lists.newArrayList((Object[])new String[]{iface}));
    }

    public AtomixClusterBuilder withMessagingInterfaces(String ... ifaces) {
        return this.withMessagingInterfaces(Lists.newArrayList((Object[])ifaces));
    }

    public AtomixClusterBuilder withMessagingInterfaces(Collection<String> ifaces) {
        this.config.getMessagingConfig().setInterfaces(Lists.newArrayList(ifaces));
        return this;
    }

    public AtomixClusterBuilder withMessagingPort(int bindPort) {
        this.config.getMessagingConfig().setPort(bindPort);
        return this;
    }

    public AtomixClusterBuilder withConnectionPoolSize(int connectionPoolSize) {
        this.config.getMessagingConfig().setConnectionPoolSize(connectionPoolSize);
        return this;
    }

    public AtomixClusterBuilder withMulticastEnabled() {
        return this.withMulticastEnabled(true);
    }

    public AtomixClusterBuilder withMulticastEnabled(boolean multicastEnabled) {
        this.config.getMulticastConfig().setEnabled(multicastEnabled);
        return this;
    }

    public AtomixClusterBuilder withMulticastAddress(Address address) {
        this.config.getMulticastConfig().setGroup(address.address());
        this.config.getMulticastConfig().setPort(address.port());
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder setBroadcastInterval(Duration interval) {
        GroupMembershipProtocolConfig protocolConfig = this.config.getProtocolConfig();
        if (protocolConfig instanceof HeartbeatMembershipProtocolConfig) {
            ((HeartbeatMembershipProtocolConfig)protocolConfig).setHeartbeatInterval(interval);
        }
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder withBroadcastInterval(Duration interval) {
        GroupMembershipProtocolConfig protocolConfig = this.config.getProtocolConfig();
        if (protocolConfig instanceof HeartbeatMembershipProtocolConfig) {
            ((HeartbeatMembershipProtocolConfig)protocolConfig).setHeartbeatInterval(interval);
        }
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder setReachabilityThreshold(int threshold) {
        GroupMembershipProtocolConfig protocolConfig = this.config.getProtocolConfig();
        if (protocolConfig instanceof HeartbeatMembershipProtocolConfig) {
            ((HeartbeatMembershipProtocolConfig)protocolConfig).setPhiFailureThreshold(threshold);
        }
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder withReachabilityThreshold(int threshold) {
        GroupMembershipProtocolConfig protocolConfig = this.config.getProtocolConfig();
        if (protocolConfig instanceof HeartbeatMembershipProtocolConfig) {
            ((HeartbeatMembershipProtocolConfig)protocolConfig).setPhiFailureThreshold(threshold);
        }
        return this;
    }

    @Deprecated
    public AtomixClusterBuilder withReachabilityTimeout(Duration timeout) {
        GroupMembershipProtocolConfig protocolConfig = this.config.getProtocolConfig();
        if (protocolConfig instanceof HeartbeatMembershipProtocolConfig) {
            ((HeartbeatMembershipProtocolConfig)protocolConfig).setFailureTimeout(timeout);
        }
        return this;
    }

    public AtomixClusterBuilder withMembershipProtocol(GroupMembershipProtocol protocol) {
        this.config.setProtocolConfig((GroupMembershipProtocolConfig)protocol.config());
        return this;
    }

    public AtomixClusterBuilder withMembershipProvider(NodeDiscoveryProvider locationProvider) {
        this.config.setDiscoveryConfig((NodeDiscoveryConfig)locationProvider.config());
        return this;
    }

    public AtomixClusterBuilder withTlsEnabled() {
        return this.withTlsEnabled(true);
    }

    public AtomixClusterBuilder withTlsEnabled(boolean tlsEnabled) {
        this.config.getMessagingConfig().getTlsConfig().setEnabled(tlsEnabled);
        return this;
    }

    public AtomixClusterBuilder withKeyStore(String keyStore) {
        this.config.getMessagingConfig().getTlsConfig().setKeyStore(keyStore);
        return this;
    }

    public AtomixClusterBuilder withKeyStorePassword(String keyStorePassword) {
        this.config.getMessagingConfig().getTlsConfig().setKeyStorePassword(keyStorePassword);
        return this;
    }

    public AtomixClusterBuilder withTrustStore(String trustStore) {
        this.config.getMessagingConfig().getTlsConfig().setTrustStore(trustStore);
        return this;
    }

    public AtomixClusterBuilder withTrustStorePassword(String trustStorePassword) {
        this.config.getMessagingConfig().getTlsConfig().setTrustStorePassword(trustStorePassword);
        return this;
    }

    public AtomixCluster build() {
        return new AtomixCluster(this.config, null);
    }
}

