/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.utils.net.Address;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelPool.class);
    private final Function<Address, CompletableFuture<Channel>> factory;
    private final int size;
    private final Map<Address, List<CompletableFuture<Channel>>> channels = Maps.newConcurrentMap();

    ChannelPool(Function<Address, CompletableFuture<Channel>> factory, int size) {
        this.factory = factory;
        this.size = size;
    }

    private List<CompletableFuture<Channel>> getChannelPool(Address address) {
        List<CompletableFuture<Channel>> channelPool = this.channels.get(address);
        if (channelPool != null) {
            return channelPool;
        }
        return this.channels.computeIfAbsent(address, e -> {
            ArrayList<Object> defaultList = new ArrayList<Object>(this.size);
            for (int i = 0; i < this.size; ++i) {
                defaultList.add(null);
            }
            return Lists.newCopyOnWriteArrayList(defaultList);
        });
    }

    private int getChannelOffset(String messageType) {
        return Math.abs(messageType.hashCode() % this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Channel> getChannel(Address address, String messageType) {
        int offset;
        List<CompletableFuture<Channel>> channelPool = this.getChannelPool(address);
        CompletableFuture<Channel> channelFuture = channelPool.get(offset = this.getChannelOffset(messageType));
        if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
            List<CompletableFuture<Channel>> list = channelPool;
            synchronized (list) {
                channelFuture = channelPool.get(offset);
                if (channelFuture == null || channelFuture.isCompletedExceptionally()) {
                    LOGGER.debug("Connecting to {}", (Object)address);
                    channelFuture = this.factory.apply(address);
                    channelFuture.whenComplete((channel, error) -> {
                        if (error == null) {
                            LOGGER.debug("Connected to {}", (Object)channel.remoteAddress());
                        } else {
                            LOGGER.debug("Failed to connect to {}", (Object)address, error);
                        }
                    });
                    channelPool.set(offset, channelFuture);
                }
            }
        }
        CompletableFuture<Channel> future = new CompletableFuture<Channel>();
        CompletableFuture<Channel> finalFuture = channelFuture;
        finalFuture.whenComplete((channel, error) -> {
            if (error == null) {
                if (!channel.isActive()) {
                    CompletableFuture<Channel> currentFuture;
                    List list = channelPool;
                    synchronized (list) {
                        currentFuture = (CompletableFuture<Channel>)channelPool.get(offset);
                        if (currentFuture == finalFuture) {
                            channelPool.set(offset, null);
                        } else if (currentFuture == null) {
                            currentFuture = this.factory.apply(address);
                            currentFuture.whenComplete((c, e) -> {
                                if (e == null) {
                                    LOGGER.debug("Connected to {}", (Object)channel.remoteAddress());
                                } else {
                                    LOGGER.debug("Failed to connect to {}", (Object)channel.remoteAddress(), e);
                                }
                            });
                            channelPool.set(offset, currentFuture);
                        }
                    }
                    if (currentFuture == finalFuture) {
                        this.getChannel(address, messageType).whenComplete((recursiveResult, recursiveError) -> {
                            if (recursiveError == null) {
                                future.complete((Channel)recursiveResult);
                            } else {
                                future.completeExceptionally((Throwable)recursiveError);
                            }
                        });
                    } else {
                        currentFuture.whenComplete((recursiveResult, recursiveError) -> {
                            if (recursiveError == null) {
                                future.complete((Channel)recursiveResult);
                            } else {
                                future.completeExceptionally((Throwable)recursiveError);
                            }
                        });
                    }
                } else {
                    future.complete((Channel)channel);
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }
}

