/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.discovery;

import com.google.common.base.Preconditions;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;

public class BootstrapDiscoveryConfig
extends NodeDiscoveryConfig {
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 1000;
    private static final int DEFAULT_FAILURE_TIMEOUT = 10000;
    private static final int DEFAULT_PHI_FAILURE_THRESHOLD = 10;
    private Duration heartbeatInterval = Duration.ofMillis(1000L);
    private int failureThreshold = 10;
    private Duration failureTimeout = Duration.ofMillis(10000L);
    private Collection<Node> nodes = Collections.emptySet();

    public NodeDiscoveryProvider.Type getType() {
        return BootstrapDiscoveryProvider.TYPE;
    }

    public Collection<Node> getNodes() {
        return this.nodes;
    }

    public BootstrapDiscoveryConfig setNodes(Collection<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public BootstrapDiscoveryConfig setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = (Duration)Preconditions.checkNotNull((Object)heartbeatInterval);
        return this;
    }

    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    public BootstrapDiscoveryConfig setFailureThreshold(int failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    public Duration getFailureTimeout() {
        return this.failureTimeout;
    }

    public BootstrapDiscoveryConfig setFailureTimeout(Duration failureTimeout) {
        this.failureTimeout = (Duration)Preconditions.checkNotNull((Object)failureTimeout);
        return this;
    }
}

