/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.ManagedClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.impl.DefaultClusterMembershipService;
import io.atomix.cluster.messaging.BroadcastService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.ManagedBroadcastService;
import io.atomix.cluster.messaging.ManagedClusterCommunicationService;
import io.atomix.cluster.messaging.ManagedClusterEventService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.DefaultClusterCommunicationService;
import io.atomix.cluster.messaging.impl.DefaultClusterEventService;
import io.atomix.cluster.messaging.impl.NettyBroadcastService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.SingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.config.ConfigMapper;
import io.atomix.utils.net.Address;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixCluster
implements Managed<Void> {
    private static final String[] DEFAULT_RESOURCES = new String[]{"cluster"};
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixCluster.class);
    protected final ManagedMessagingService messagingService;
    protected final ManagedBroadcastService broadcastService;
    protected final ManagedClusterMembershipService membershipService;
    protected final ManagedClusterCommunicationService communicationService;
    protected final ManagedClusterEventService eventService;
    protected volatile CompletableFuture<Void> openFuture;
    protected volatile CompletableFuture<Void> closeFuture;
    private final ThreadContext threadContext = new SingleThreadContext("atomix-cluster-%d");
    private final AtomicBoolean started = new AtomicBoolean();

    private static String[] withDefaultResources(String config) {
        return (String[])Streams.concat((Stream[])new Stream[]{Stream.of(config), Stream.of(DEFAULT_RESOURCES)}).toArray(String[]::new);
    }

    private static ClusterConfig config(String[] resources, ClassLoader classLoader) {
        return (ClusterConfig)new ConfigMapper(classLoader).loadResources(ClusterConfig.class, resources);
    }

    public static Builder builder() {
        return AtomixCluster.builder(Thread.currentThread().getContextClassLoader());
    }

    public static Builder builder(ClassLoader classLoader) {
        return AtomixCluster.builder(AtomixCluster.config(DEFAULT_RESOURCES, classLoader));
    }

    public static Builder builder(String config) {
        return AtomixCluster.builder(config, Thread.currentThread().getContextClassLoader());
    }

    public static Builder builder(String config, ClassLoader classLoader) {
        return new Builder(AtomixCluster.config(AtomixCluster.withDefaultResources(config), classLoader));
    }

    public static Builder builder(ClusterConfig config) {
        return new Builder(config);
    }

    public AtomixCluster(String configFile) {
        this(AtomixCluster.loadConfig(new File(System.getProperty("user.dir"), configFile), Thread.currentThread().getContextClassLoader()));
    }

    public AtomixCluster(File configFile) {
        this(AtomixCluster.loadConfig(configFile, Thread.currentThread().getContextClassLoader()));
    }

    public AtomixCluster(ClusterConfig config) {
        this.messagingService = AtomixCluster.buildMessagingService(config);
        this.broadcastService = AtomixCluster.buildBroadcastService(config);
        this.membershipService = AtomixCluster.buildClusterMembershipService(config, this.messagingService, this.broadcastService);
        this.communicationService = AtomixCluster.buildClusterMessagingService(this.membershipService, this.messagingService);
        this.eventService = AtomixCluster.buildClusterEventService(this.membershipService, this.messagingService);
    }

    public BroadcastService getBroadcastService() {
        return this.broadcastService;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public ClusterMembershipService getMembershipService() {
        return this.membershipService;
    }

    public ClusterCommunicationService getCommunicationService() {
        return this.communicationService;
    }

    public ClusterEventService getEventService() {
        return this.eventService;
    }

    public synchronized CompletableFuture<Void> start() {
        if (this.closeFuture != null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("AtomixCluster instance " + (this.closeFuture.isDone() ? "shutdown" : "shutting down")));
        }
        if (this.openFuture != null) {
            return this.openFuture;
        }
        this.openFuture = this.startServices().thenComposeAsync(v -> this.completeStartup(), (Executor)this.threadContext);
        return this.openFuture;
    }

    protected CompletableFuture<Void> startServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.messagingService.start().thenComposeAsync(v -> this.broadcastService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.membershipService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.communicationService.start(), (Executor)this.threadContext)).thenComposeAsync(v -> this.eventService.start(), (Executor)this.threadContext)).thenApply(v -> null);
    }

    protected CompletableFuture<Void> completeStartup() {
        this.started.set(true);
        LOGGER.info("Started");
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public synchronized CompletableFuture<Void> stop() {
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.closeFuture = this.stopServices().thenComposeAsync(v -> this.completeShutdown(), (Executor)this.threadContext);
        return this.closeFuture;
    }

    protected CompletableFuture<Void> stopServices() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.communicationService.stop().exceptionally(e -> null)).thenComposeAsync(v -> this.eventService.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> this.membershipService.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> this.broadcastService.stop(), (Executor)this.threadContext)).exceptionally(e -> null)).thenComposeAsync(v -> this.messagingService.stop(), (Executor)this.threadContext)).exceptionally(e -> null);
    }

    protected CompletableFuture<Void> completeShutdown() {
        this.threadContext.close();
        this.started.set(false);
        LOGGER.info("Stopped");
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    private static ClusterConfig loadConfig(File config, ClassLoader classLoader) {
        return (ClusterConfig)new ConfigMapper(classLoader).loadResources(ClusterConfig.class, new String[]{config.getAbsolutePath()});
    }

    protected static ManagedMessagingService buildMessagingService(ClusterConfig config) {
        return NettyMessagingService.builder().withName(config.getName()).withAddress(config.getLocalMember().getAddress()).build();
    }

    protected static ManagedBroadcastService buildBroadcastService(ClusterConfig config) {
        return NettyBroadcastService.builder().withLocalAddress(config.getLocalMember().getAddress()).withGroupAddress(config.getMulticastAddress()).withEnabled(config.isMulticastEnabled()).build();
    }

    protected static ManagedClusterMembershipService buildClusterMembershipService(ClusterConfig config, MessagingService messagingService, BroadcastService broadcastService) {
        Member localMember;
        if (config.getLocalMember() == null) {
            Address address = Address.local();
            localMember = Member.member(address);
        } else {
            localMember = new Member(config.getLocalMember());
        }
        return new DefaultClusterMembershipService(localMember, config.getMembers().stream().map(Member::new).collect(Collectors.toList()), messagingService, broadcastService, config.getMembershipConfig());
    }

    protected static ManagedClusterCommunicationService buildClusterMessagingService(ClusterMembershipService membershipService, MessagingService messagingService) {
        return new DefaultClusterCommunicationService(membershipService, messagingService);
    }

    protected static ManagedClusterEventService buildClusterEventService(ClusterMembershipService membershipService, MessagingService messagingService) {
        return new DefaultClusterEventService(membershipService, messagingService);
    }

    public static class Builder
    implements io.atomix.utils.Builder<AtomixCluster> {
        protected final ClusterConfig config;

        protected Builder() {
            this(new ClusterConfig());
        }

        protected Builder(ClusterConfig config) {
            this.config = (ClusterConfig)Preconditions.checkNotNull((Object)config);
        }

        public Builder withClusterName(String clusterName) {
            this.config.setName(clusterName);
            return this;
        }

        public Builder withLocalMember(String localMember) {
            this.config.setLocalMemberId(localMember);
            return this;
        }

        public Builder withLocalMember(Member localMember) {
            this.config.setLocalMember(localMember.config());
            return this;
        }

        public Builder withMembers(Member ... members) {
            return this.withMembers(Arrays.asList((Object[])Preconditions.checkNotNull((Object)members)));
        }

        public Builder withMembers(Collection<Member> members) {
            members.forEach(member -> this.config.addMember(member.config()));
            return this;
        }

        public Builder withMulticastEnabled() {
            return this.withMulticastEnabled(true);
        }

        public Builder withMulticastEnabled(boolean multicastEnabled) {
            this.config.setMulticastEnabled(multicastEnabled);
            return this;
        }

        public Builder withMulticastAddress(Address address) {
            this.config.setMulticastAddress(address);
            return this;
        }

        public AtomixCluster build() {
            return new AtomixCluster(this.config);
        }
    }
}

