/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.utils.net.Address;
import java.util.Objects;

public class Node {
    private final NodeId id;
    private final Type type;
    private final Address address;
    private final String zone;
    private final String rack;
    private final String host;

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(String nodeId) {
        return Node.builder(NodeId.from(nodeId));
    }

    public static Builder builder(NodeId nodeId) {
        return new Builder((NodeId)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId cannot be null"));
    }

    public static Node core(NodeId nodeId, Address address) {
        return Node.builder(nodeId).withType(Type.CORE).withAddress(address).build();
    }

    public static Node data(NodeId nodeId, Address address) {
        return Node.builder(nodeId).withType(Type.DATA).withAddress(address).build();
    }

    public static Node client(NodeId nodeId, Address address) {
        return Node.builder(nodeId).withType(Type.CLIENT).withAddress(address).build();
    }

    public Node(NodeConfig config) {
        this(config.getId(), config.getType(), config.getAddress(), config.getZone(), config.getRack(), config.getHost());
    }

    protected Node(NodeId id, Type type, Address address, String zone, String rack, String host) {
        this.id = (NodeId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
        this.address = (Address)Preconditions.checkNotNull((Object)address, (Object)"address cannot be null");
        this.zone = zone;
        this.rack = rack;
        this.host = host;
    }

    public NodeId id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public Address address() {
        return this.address;
    }

    public State getState() {
        throw new UnsupportedOperationException();
    }

    public String zone() {
        return this.zone;
    }

    public String rack() {
        return this.rack;
    }

    public String host() {
        return this.host;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object object) {
        return object instanceof Node && ((Node)object).id.equals(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("type", (Object)this.type).add("address", (Object)this.address).add("zone", (Object)this.zone).add("rack", (Object)this.rack).add("host", (Object)this.host).omitNullValues().toString();
    }

    public static class Builder
    implements io.atomix.utils.Builder<Node> {
        protected NodeId id;
        protected Type type;
        protected Address address;
        protected String zone;
        protected String rack;
        protected String host;

        protected Builder(NodeId id) {
            this.id = id;
        }

        public Builder withId(NodeId id) {
            this.id = (NodeId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
            return this;
        }

        public Builder withType(Type type) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder withAddress(String address) {
            return this.withAddress(Address.from((String)address));
        }

        public Builder withAddress(String host, int port) {
            return this.withAddress(Address.from((String)host, (int)port));
        }

        public Builder withAddress(int port) {
            return this.withAddress(Address.from((int)port));
        }

        public Builder withAddress(Address address) {
            this.address = (Address)Preconditions.checkNotNull((Object)address, (Object)"address cannot be null");
            return this;
        }

        public Builder withZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder withRack(String rack) {
            this.rack = rack;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Node build() {
            if (this.id == null) {
                this.id = NodeId.from(this.address.address().getHostName());
            }
            return new Node(this.id, this.type, this.address, this.zone, this.rack, this.host);
        }
    }

    public static enum State {
        ACTIVE,
        INACTIVE;

    }

    public static enum Type {
        CORE,
        DATA,
        CLIENT;

    }
}

